package jprofilegrid.view.gridparameters;

import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

import jprofilegrid.calculations.Sequence;
import jprofilegrid.presenter.SortableSequence;

public class GrepSequenceJComboBox extends JComboBox implements KeyListener
{
	private static final long serialVersionUID = 790268930757172746L;
	private List<Sequence> sequences = new ArrayList<Sequence>(),
						   sortedSequences = new ArrayList<Sequence>();

	public GrepSequenceJComboBox()
	{
		setModel(new DefaultComboBoxModel(new String[] {"Load Alignment                 "}));
		getEditor().getEditorComponent().addKeyListener(this);
	}

	public void setSequenceListSorted(boolean sorted)
	{
		super.removeAllItems();

		List<Sequence> displayedSequences = sorted ? sortedSequences : sequences;

		for(Sequence sequence : displayedSequences)
			super.addItem(sequence.getName());
	}

	public void setSequences(List<Sequence> sequences)
	{
		removeAllItems();

		Queue<SortableSequence> sequenceSortingQueue = new PriorityQueue<SortableSequence>();
		for(int i = 0; i < sequences.size(); i++)
		{
			Sequence sequence = sequences.get(i);
			this.sequences.add(sequence);
			sequenceSortingQueue.add(new SortableSequence(sequence, i));
			super.addItem(sequence.getName());
		}

		while(!sequenceSortingQueue.isEmpty())
			sortedSequences.add(sequenceSortingQueue.remove().getSequence());

		setMaximumSize(getSize());
		setMinimumSize(getSize());
		setPreferredSize(getSize());
	}

	public Sequence getSelectedSequence()
	{
		if( super.getSelectedItem() != null )
		{
			// Get the name of the selected element from the filtered list.
			String selectedValue = super.getSelectedItem().toString();

			// Match that name to the complete list.
			for( int i = 0; i < sequences.size(); i++ )
			{
				Sequence sequence = sequences.get(i);
				if( selectedValue.equalsIgnoreCase(sequence.getName()) )
					return sequence;
			}
		}

		return null;
	}

	public int getSelectedSequenceIndex()
	{
		if( super.getSelectedItem() != null )
		{
			// Get the name of the selected element from the filtered list.
			String selectedValue = super.getSelectedItem().toString();

			// Match that name to the complete list.
			for( int i = 0; i < sequences.size(); i++ )
			{
				Sequence sequence = sequences.get(i);
				if( selectedValue.equalsIgnoreCase(sequence.getName()) )
					return i;
			}
		}

		return 0;
	}

	public void removeAllItems()
	{
		sequences.clear();
		sortedSequences.clear();
		super.removeAllItems();
	}


	private void filterItemsList(String filter)
	{
		ActionListener[] actionListeners = getActionListeners();
		for(ActionListener actionListener : actionListeners)
			removeActionListener(actionListener);

		super.removeAllItems();

		List<String> matchingItems = new ArrayList<String>();

		try
		{
			Pattern pattern = Pattern.compile(filter);
			for(Sequence sequence : sequences)
			{
				String sequenceName = sequence.getName();

				if(pattern.matcher(sequenceName).find())
					matchingItems.add(sequenceName);
			}
		}
		catch(PatternSyntaxException e)
		{
			return;
		}

		setModel(new DefaultComboBoxModel(matchingItems.toArray()));

		for(ActionListener actionListener : actionListeners)
			addActionListener(actionListener);
	}

	@Override
	public void keyReleased(KeyEvent keyEvent)
	{
		char c = keyEvent.getKeyChar();

		if( c >= 32 && c <= 127 || c == 8 )
		{
			hidePopup();

			JTextField editorJTextField = (JTextField)(getEditor().getEditorComponent());

			String currVal = editorJTextField.getText();
			filterItemsList(currVal);
			editorJTextField.setText(currVal);
			showPopup();
		}

	}
	@Override
	public void keyPressed(KeyEvent keyEvent){}
	@Override
	public void keyTyped(KeyEvent keyEvent){}
}
