package jprofilegrid.view.gridparameters;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;

public class GridParametersJPanel extends JPanel implements ActionListener, KeyListener
{
	private static final long serialVersionUID = 4477656123215277926L;
	private static final int SHOW_VALUES_DISABLED = 3;

	private GridBagConstraints constraints = new GridBagConstraints();
	private GridBagLayout anaylzePanelOptionsAreaLayout = new GridBagLayout();
	private Border border = new LineBorder(new java.awt.Color(0, 100, 0), 1);
	private TitledBorder analyzePanelBorder = BorderFactory.createTitledBorder(border, "Grid Parameters");

	private JTextField startAtBlank = new JTextField(String.valueOf(1), 5);

	private GrepSequenceJComboBox referenceSequenceBlank = new GrepSequenceJComboBox();

	private JComboBox sortTypeBlank = new JComboBox(new String[] {"Load Alignment            "}),
					  integerOrPercentageOrResidue = new JComboBox(new String[] {"Integer", "Percentage", "Residue"});

	private JComboBox identifySeqIfResIsAbsOrPres = new JComboBox(new String[] {"Present", "Absent"});
	private JTextArea identifySeqLabel 			  = new JTextArea("Identify sequences where\nselected residue is:");
	private JCheckBox frequencyColorsJCheckBox 	  = new JCheckBox(),
					  ascendingJCheckBox 		  = new JCheckBox(),
					  skipGapsJCheckBox 		  = new JCheckBox(),
					  showValuesJCheckBox 		  = new JCheckBox(),
					  sortSequenceListsJCheckBox  = new JCheckBox(),
					  metaDataJCheckBox			  = new JCheckBox();

	private JButton frequencyColorsButton 		   = new JButton("Frequency Colors"),
					identifySequencesButton 	   = new JButton("Sequences"),
					profileGridOverviewTypeJButton = new JButton("ProfileGrid"),
					alignmentOverviewTypeJButton   = new JButton("Alignment"),
					highlightJButton			   = new JButton("Highlighting"),
					metaDataJButton				   = new JButton("Meta Data");

	private JLabel sortSequenceListsJLabel	  = new JLabel("Sort Sequence Lists:"),
				   referenceSequenceLabel	  = new JLabel("Reference Sequence:"),
				   positionRulerLabel 		  = new JLabel("Position Ruler:"),
				   skipGapsLabel		      = new JLabel("Skip Gaps"),
				   startAtLabel 			  = new JLabel("Start At"),
				   sortAscendingAndTypeLabel  = new JLabel("Sort Ascending/Type:"),
				   enableFrequencyColorsLabel = new JLabel("Frequency Colors:"),
				   showValuesLabel			  = new JLabel("Show Values:"),
				   overviewLabel			  = new JLabel("Show Overview:"),
				   highlightJLabel			  = new JLabel("Highlighting:"),
				   metaDataJLabel			  = new JLabel("Enable Meta Data Filters:");

	private JPanel positionRulerJPanel = new JPanel(new GridBagLayout()),
				   frequencyColorsJPanel = new JPanel(new GridBagLayout()),
				   sortAndDualDisplayJPanel = new JPanel(new GridBagLayout()),
				   overviewTypesJPanel = new JPanel(new GridBagLayout());

	private ProfileGridPresenter profileGridPresenter;

	public GridParametersJPanel(ProfileGridPresenter profileGridPresenter)
	{
		this.profileGridPresenter = profileGridPresenter;
	}

	public void actionPerformed(ActionEvent e)
	{
		Object s = e.getSource();

		if( s == highlightJButton )
		{
			profileGridPresenter.openHighlightJFrame();
			return;
		}

		if( s == sortSequenceListsJCheckBox )
		{
			profileGridPresenter.updateSortSequenceLists();
			return;
		}

		if( s == frequencyColorsButton )
		{
			profileGridPresenter.showFrequencyColorsSelectionJFrame();
			return;
		}

		if( s == profileGridOverviewTypeJButton )
		{
			profileGridPresenter.showProfileGridOverviewJFrame();
			return;
		}

		if( s == identifySequencesButton )
		{
			profileGridPresenter.openIdentifySequencesDialog();
			return;
		}

		if( s == identifySeqIfResIsAbsOrPres )
		{
			profileGridPresenter.setSelectedAminoAcid();
			return;
		}

		if( s == alignmentOverviewTypeJButton )
		{
			profileGridPresenter.showAlignmentOverviewJFrame();
			return;
		}

		if(s == metaDataJButton)
		{
			profileGridPresenter.showMetaDataColumnsJFrame();
			return;
		}

		if(s == sortTypeBlank || s == ascendingJCheckBox)
		{
			profileGridPresenter.recalculateSorting();
			return;
		}

		if(s == metaDataJCheckBox)
		{
			profileGridPresenter.onFilterchange();
			return;
		}

		profileGridPresenter.updateTopProfileGrid();
	}

	public void initializeAnalyzePanel()
	{
		analyzePanelBorder.setTitleColor(new java.awt.Color(0, 0, 0));
		setBorder(analyzePanelBorder);
		setLayout(anaylzePanelOptionsAreaLayout);

		addListeners();

		identifySeqLabel.setBackground(getBackground());
		identifySeqLabel.setFont(sortSequenceListsJLabel.getFont());
		identifySeqLabel.setEditable(false);

		skipGapsJCheckBox.setSelected(true);
		frequencyColorsJCheckBox.setSelected(true);
		ascendingJCheckBox.setSelected(true);
		showValuesJCheckBox.setSelected(true);

		initializeLabels();

		GridBagConstraintsInitializer.resetConstraints(constraints);

		initializeSortAndDualDisplayJPanel();
		constraints.gridx = 1;
		constraints.gridy = 2;
		constraints.gridwidth = 4;
		add(referenceSequenceBlank, constraints);

		constraints.anchor = GridBagConstraints.LINE_START;
		constraints.gridx = 1;
		constraints.gridy = 3;
		constraints.gridwidth = 10;
		referenceSequenceBlank.setEditable(true);
		add(sortAndDualDisplayJPanel, constraints);

		constraints.gridy++;
		constraints.gridx = 1;
		highlightJButton.addActionListener(this);
		add(highlightJButton, constraints);

		constraints.gridx = 1;
		constraints.gridy = 0;
		initializePositionRulerJPanel();
		add(positionRulerJPanel, constraints);

		constraints.gridx = 1;
		constraints.gridwidth = 10;
		constraints.gridy = 4;

		constraints.gridy++;
		constraints.gridx = 1;
		constraints.gridwidth = 1;
		constraints.weightx = 0;
		add(ascendingJCheckBox, constraints);

		constraints.gridx = 2;
		constraints.gridwidth = 4;
		add(sortTypeBlank, constraints);

		constraints.gridy++;
		constraints.gridx = 1;
		constraints.gridwidth = 1;
		add(frequencyColorsJCheckBox, constraints);

		constraints.gridx = 2;
		constraints.gridwidth = 4;
		add(frequencyColorsButton, constraints);

		constraints.gridy++;
		constraints.gridx = 1;
		constraints.gridwidth = 1;
		add(showValuesJCheckBox, constraints);

		constraints.gridx++;
		constraints.gridwidth = 3;
		add(integerOrPercentageOrResidue, constraints);

		constraints.gridy++;
		constraints.gridx = 1;
		metaDataJCheckBox.addActionListener(this);
		metaDataJCheckBox.setSelected(true);
		add(metaDataJCheckBox, constraints);

		constraints.gridx++;
		metaDataJButton.addActionListener(this);
		add(metaDataJButton, constraints);

		initializeOverviewTypesJPanel();
		constraints.gridy++;
		constraints.gridx = 1;
		constraints.gridwidth = 2;
		add(overviewTypesJPanel, constraints);
	}

	private void initializeLabels()
	{
		GridBagConstraintsInitializer.resetConstraints(constraints);

		constraints.anchor = GridBagConstraints.LINE_END;

		add(positionRulerLabel, constraints);

		constraints.gridy = 2;
		constraints.gridheight = 1;

		add(referenceSequenceLabel, constraints);

		constraints.gridy++;

		add(sortSequenceListsJLabel,constraints);

		constraints.gridy++;
		add(highlightJLabel, constraints);

		constraints.gridy++;
		add(sortAscendingAndTypeLabel, constraints);

		constraints.gridy++;
		add(enableFrequencyColorsLabel, constraints);

		constraints.gridy++;
		add(showValuesLabel, constraints);

		constraints.gridy++;
		add(metaDataJLabel, constraints);

		constraints.gridy++;
		add(overviewLabel, constraints);

		initializeFrequencyColorsJPanel();
		constraints.gridy++;
		constraints.gridwidth = 5;
		add(frequencyColorsJPanel, constraints);
	}

	private void initializeSortAndDualDisplayJPanel()
	{
		GridBagConstraints sortAndDualDisplayJPanelConstraints = new GridBagConstraints();
		GridBagConstraintsInitializer.resetConstraints(sortAndDualDisplayJPanelConstraints);

		constraints.anchor = GridBagConstraints.LINE_START;
		sortAndDualDisplayJPanelConstraints.ipadx = 5;

		sortAndDualDisplayJPanelConstraints.gridx = 0;
		sortAndDualDisplayJPanelConstraints.gridy = 0;
		sortAndDualDisplayJPanelConstraints.gridwidth = 1;
		sortAndDualDisplayJPanelConstraints.gridheight = 1;
		sortAndDualDisplayJPanel.add(sortSequenceListsJCheckBox, sortAndDualDisplayJPanelConstraints);
		sortSequenceListsJCheckBox.addActionListener(this);

	}

	private void initializeOverviewTypesJPanel()
	{
		GridBagConstraints overviewTypesJPanelConstraints = new GridBagConstraints();
		GridBagConstraintsInitializer.resetConstraints(overviewTypesJPanelConstraints);

		constraints.anchor = GridBagConstraints.LINE_START;
		overviewTypesJPanelConstraints.ipadx = 5;

		overviewTypesJPanelConstraints.gridx = 0;
		overviewTypesJPanelConstraints.gridy = 0;
		overviewTypesJPanelConstraints.gridwidth = 1;
		overviewTypesJPanelConstraints.gridheight = 1;
		overviewTypesJPanel.add(profileGridOverviewTypeJButton, overviewTypesJPanelConstraints);
		profileGridOverviewTypeJButton.addActionListener(this);

		overviewTypesJPanelConstraints.gridx++;
		overviewTypesJPanel.add(alignmentOverviewTypeJButton, overviewTypesJPanelConstraints);
		alignmentOverviewTypeJButton.addActionListener(this);
	}

	private void initializePositionRulerJPanel()
	{
		GridBagConstraints positionRulerJPanelConstraints = new GridBagConstraints();
		GridBagConstraintsInitializer.resetConstraints(positionRulerJPanelConstraints);

		positionRulerJPanelConstraints.ipadx = 5;
		positionRulerJPanel.add(skipGapsLabel, positionRulerJPanelConstraints);

		positionRulerJPanelConstraints.gridx++;
		positionRulerJPanel.add(startAtLabel, positionRulerJPanelConstraints);

		positionRulerJPanelConstraints.gridy++;
		positionRulerJPanelConstraints.fill = GridBagConstraints.HORIZONTAL;
		positionRulerJPanel.add(startAtBlank, positionRulerJPanelConstraints);

		positionRulerJPanelConstraints.gridx--;
		positionRulerJPanelConstraints.fill = GridBagConstraints.NONE;
		positionRulerJPanel.add(skipGapsJCheckBox, positionRulerJPanelConstraints);
	}

	private void initializeFrequencyColorsJPanel()
	{
		GridBagConstraints frequencyColorsJPanelConstraints = new GridBagConstraints();
		GridBagConstraintsInitializer.resetConstraints(frequencyColorsJPanelConstraints);

		frequencyColorsJPanelConstraints.ipadx = 5;
		frequencyColorsJPanelConstraints.gridwidth = 1;
		frequencyColorsJPanelConstraints.gridheight = 2;

		frequencyColorsJPanel.add(identifySeqLabel, frequencyColorsJPanelConstraints);

		frequencyColorsJPanelConstraints.gridx++;
		frequencyColorsJPanelConstraints.gridheight = 1;
		frequencyColorsJPanel.add(identifySeqIfResIsAbsOrPres, frequencyColorsJPanelConstraints);

		frequencyColorsJPanelConstraints.gridx++;
		frequencyColorsJPanel.add(identifySequencesButton, frequencyColorsJPanelConstraints);
	}

	private void addListeners()
	{
		startAtBlank.addKeyListener(this);
		skipGapsJCheckBox.addActionListener((ActionListener) this);
		ascendingJCheckBox.addActionListener(this);
		sortTypeBlank.addActionListener(this);
		referenceSequenceBlank.addActionListener(this);

		integerOrPercentageOrResidue.addActionListener(this);
		showValuesJCheckBox.addActionListener(this);
		identifySeqIfResIsAbsOrPres.addActionListener(this);
		frequencyColorsButton.addActionListener(this);
		frequencyColorsJCheckBox.addActionListener(this);
		identifySequencesButton.addActionListener(this);
	}


	public void switchIntegerOrPercentageOrResidue(AnalysisOptions analysisOptions)
	{
		analysisOptions.showValuesAs = showValueAs();
		profileGridPresenter.updateTopProfileGrid();
	}

	public void selectPercentage()
	{
		integerOrPercentageOrResidue.removeActionListener(this);
		integerOrPercentageOrResidue.setSelectedIndex(1);
		integerOrPercentageOrResidue.addActionListener(this);
	}

	public boolean skipGapsEnabled()
	{
		return skipGapsJCheckBox.isSelected();
	}

	public boolean isAscendingSort()
	{
		return ascendingJCheckBox.isSelected();
	}

	public int getSortType()
	{
		return sortTypeBlank.getSelectedIndex();
	}

	public String getSortTypeName()
	{
		return sortTypeBlank.getSelectedItem().toString();
	}

	public int getPositionStart()
	{
		try
		{
			return Integer.parseInt(startAtBlank.getText());
		}
		catch(NumberFormatException numberFormatException)
		{
			return 1;
		}
	}

	public boolean frequencyColorsEnabled()
	{
		return frequencyColorsJCheckBox.isSelected();
	}

	public int showValueAs()
	{
		if(showValuesJCheckBox.isSelected())
		{
			integerOrPercentageOrResidue.setEnabled(true);
			return integerOrPercentageOrResidue.getSelectedIndex();
		}
		else
		{
			integerOrPercentageOrResidue.setEnabled(false);
			return SHOW_VALUES_DISABLED;
		}
	}

	public boolean getDisplayedResidueIfPresent()
	{
		return identifySeqIfResIsAbsOrPres.getSelectedIndex() == 0;
	}

	public void setSortTypeBlank( String[] data )
	{
		sortTypeBlank.removeActionListener(this);
		sortTypeBlank.setModel(new DefaultComboBoxModel(data));
		sortTypeBlank.addActionListener(this);
	}

	public void keyPressed(KeyEvent e) {}

	public void keyReleased(KeyEvent e)
	{
		if( e.getSource() == startAtBlank )
			profileGridPresenter.updateTopProfileGrid();
	}

	public void enableFrequencyColorsButton()
	{
		frequencyColorsButton.setEnabled(true);
	}

	public void disableFrequencyColorsButton()
	{
		frequencyColorsButton.setEnabled(false);
	}

	public void keyTyped(KeyEvent e)
	{
	}

	public JPanel getPositionRulerJPanel()
	{
		return positionRulerJPanel;
	}

	public JPanel getFrequencyColorsJPanel()
	{
		return frequencyColorsJPanel;
	}

	public JPanel getSortAndDualDisplayJPanel()
	{
		return sortAndDualDisplayJPanel;
	}

	public JPanel getOverviewTypesJPanel()
	{
		return overviewTypesJPanel;
	}

	public JCheckBox getSortSequenceListsJCheckBox()
	{
		return sortSequenceListsJCheckBox;
	}

	public GrepSequenceJComboBox getReferenceSequenceBlank()
	{
		return referenceSequenceBlank;
	}

	public boolean getSortingEnabled()
	{
		return sortSequenceListsJCheckBox.isSelected();
	}

	public boolean getMetaDataFilteringEnabled()
	{
		return metaDataJCheckBox.isSelected();
	}
}
