package jprofilegrid.view.highlight;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import jprofilegrid.presenter.ColorManager;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.ColorComboBoxRenderer;
import jprofilegrid.view.OpenWindowsMenu;
import jprofilegrid.view.gridparameters.GrepSequenceJComboBox;
import jxl.format.Colour;
import jxl.format.RGB;

public class HighlightJFrame extends JFrame implements ActionListener, KeyListener
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private GrepSequenceJComboBox highlightSequenceBlank = new GrepSequenceJComboBox();
	private JComboBox highlightSequenceColor = new JComboBox(new String[] {"Load Alignment"});

	private JRadioButton sequenceRadioButton = new JRadioButton("Sequence"),
						 valuesRadioButton   = new JRadioButton("Values"),
						 aboveRadioButton = new JRadioButton("\u2265"),
						 equalsRadioButton = new JRadioButton("="),
						 belowRadioButton = new JRadioButton("\u2264");

	private JPanel highlightSequenceJPanel = new JPanel(),
				   highlightValuesJPanel = new JPanel();

	private ButtonGroup buttonGroup = new ButtonGroup(),
						aboveBelowGroup = new ButtonGroup();

	private JLabel highlightBasedOnLabel  = new JLabel("Highlight Based On: "),
				   highlightSequenceLabel = new JLabel("Highlight Sequence:" ),
				   highlightColorLabel	  = new JLabel("Highlight Color:"),
				   highlightValuesLabel   = new JLabel("Highlight Value:");

	private JTextField highlightValuesJTextField = new JTextField("1", 5);

	private GridBagLayout mainLayout = new GridBagLayout();
	private GridBagConstraints constraints = new GridBagConstraints();

	private MenuBar menuBar = new MenuBar();
	private Menu fileMenu = new Menu("File");
	private Menu aboutMenu = new Menu("About");
	private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
	private MenuItem quitMenuItem = new MenuItem("Quit");

	private ProfileGridPresenter profileGridPresenter;

	public HighlightJFrame(ProfileGridPresenter profileGridPresenter)
	{
		this.profileGridPresenter = profileGridPresenter;

		highlightValuesJTextField.addKeyListener(this);
		buttonGroup.add(sequenceRadioButton);
		buttonGroup.add(valuesRadioButton);

		aboveRadioButton.addActionListener(this);
		equalsRadioButton.addActionListener(this);
		belowRadioButton.addActionListener(this);

		aboveRadioButton.setSelected(true);

		aboveBelowGroup.add(aboveRadioButton);
		aboveBelowGroup.add(equalsRadioButton);
		aboveBelowGroup.add(belowRadioButton);

		sequenceRadioButton.addActionListener(this);
		valuesRadioButton.addActionListener(this);
		sequenceRadioButton.setSelected(true);

		setTitle("Highlighting");

		highlightSequenceColor.setRenderer(new ColorComboBoxRenderer());

		setLayout(mainLayout);

		constraints.gridx = 0;
		constraints.gridy = 0;

		initializeMenuBar();

		highlightSequenceBlank.setEditable(true);
		highlightSequenceBlank.addActionListener(this);

		JPanel radioButtonJPanel = new JPanel();
		radioButtonJPanel.setLayout(new FlowLayout());
		radioButtonJPanel.add(highlightBasedOnLabel);
		radioButtonJPanel.add(sequenceRadioButton);

		constraints.anchor = GridBagConstraints.CENTER;
		radioButtonJPanel.add(valuesRadioButton);

		add(radioButtonJPanel, constraints);

		JPanel highlightColorJPanel = new JPanel();
		highlightColorJPanel.setLayout(new FlowLayout());
		highlightColorJPanel.add(highlightColorLabel);
		highlightColorJPanel.add(highlightSequenceColor);

		constraints.gridy++;
		add(highlightColorJPanel, constraints);

		highlightSequenceJPanel.setLayout(new GridBagLayout());
		GridBagConstraints highlightSequenceConstraints = new GridBagConstraints();
		highlightSequenceConstraints.gridx = 0;
		highlightSequenceConstraints.gridy = 0;
		highlightSequenceConstraints.anchor = GridBagConstraints.LINE_END;
		highlightSequenceJPanel.add(highlightSequenceLabel, highlightSequenceConstraints);
		highlightSequenceConstraints.gridx++;
		highlightSequenceConstraints.anchor = GridBagConstraints.LINE_START;
		highlightSequenceJPanel.add(highlightSequenceBlank, highlightSequenceConstraints);

		Border highlightSequenceLineBorder = new LineBorder(new java.awt.Color(101, 115, 131), 1);
		TitledBorder highlightSequenceTitleBorder = BorderFactory.createTitledBorder(highlightSequenceLineBorder, "Sequence");
		highlightSequenceTitleBorder.setTitleColor(new java.awt.Color(0, 0, 0));
		highlightSequenceJPanel.setBorder(highlightSequenceTitleBorder);

		constraints.gridy++;
		add(highlightSequenceJPanel, constraints);

		highlightValuesJPanel.setLayout(new GridBagLayout());
		GridBagConstraints highlightValuesConstraints = new GridBagConstraints();
		highlightValuesConstraints.gridx = 0;
		highlightValuesConstraints.gridy = 0;
		highlightValuesConstraints.anchor = GridBagConstraints.CENTER;
		JPanel highlightThresholdTypeJPanel = new JPanel();
		highlightThresholdTypeJPanel.setLayout(new FlowLayout());
		highlightThresholdTypeJPanel.add(aboveRadioButton);
		highlightThresholdTypeJPanel.add(equalsRadioButton);
		highlightThresholdTypeJPanel.add(belowRadioButton);
		highlightValuesConstraints.gridwidth = 2;
		highlightValuesJPanel.add(highlightThresholdTypeJPanel, highlightValuesConstraints);

		highlightValuesConstraints.gridy++;
		highlightValuesConstraints.gridwidth = 1;
		highlightValuesJPanel.add(highlightValuesLabel, highlightValuesConstraints);
		highlightValuesConstraints.gridx++;
		highlightValuesConstraints.anchor = GridBagConstraints.LINE_START;
		highlightValuesJPanel.add(highlightValuesJTextField, highlightValuesConstraints);

		Border highlightValuesLineBorder = new LineBorder(new java.awt.Color(195, 86, 23), 1);
		TitledBorder highlightValuesTitleBorder = BorderFactory.createTitledBorder(highlightValuesLineBorder, "Value");
		highlightValuesTitleBorder.setTitleColor(new java.awt.Color(0, 0, 0));
		highlightValuesJPanel.setBorder(highlightValuesTitleBorder);

		constraints.gridy++;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		add(highlightValuesJPanel, constraints);

		setResizable(false);

		highlightSequenceColor.removeAllItems();

		Colour[] SORTED_COLOURS = ColorManager.getSortedColours();
		for( int i = 0; i < SORTED_COLOURS.length; i++ )
			highlightSequenceColor.addItem(SORTED_COLOURS[i]);

		highlightSequenceColor.setSelectedItem(Colour.PINK);

		RGB currentColor = Colour.PINK.getDefaultRGB();
		Color color = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue());
		highlightSequenceColor.setForeground(color);

		highlightSequenceColor.addActionListener(this);

		pack();
	}

	private void initializeMenuBar()
	{
		menuBar.add(fileMenu);
		OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
		addWindowListener(openWindowsMenu);
		menuBar.add(openWindowsMenu);
		menuBar.add(aboutMenu);
		quitMenuItem.addActionListener(this);
		aboutMenu.add(aboutMenuItem);
		aboutMenuItem.addActionListener(this);
		fileMenu.add(quitMenuItem);
		setMenuBar((menuBar));
	}

	public void actionPerformed(ActionEvent actionEvent)
	{
		Object source = actionEvent.getSource();

		if(source == highlightSequenceColor)
		{
			RGB currentColor = ColorManager.getSortedColours()[highlightSequenceColor.getSelectedIndex()].getDefaultRGB();
			Color color = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue());
			highlightSequenceColor.setForeground(color);
		}

		if(source == sequenceRadioButton || source == valuesRadioButton)
			profileGridPresenter.onHighlightTypeChanged();

		if(source == aboveRadioButton && aboveRadioButton.isSelected())
			profileGridPresenter.onHighlightTypeChanged();

		if(source == equalsRadioButton && equalsRadioButton.isSelected())
			profileGridPresenter.onHighlightTypeChanged();

		if(source == belowRadioButton && belowRadioButton.isSelected())
			profileGridPresenter.onHighlightTypeChanged();

		profileGridPresenter.updateTopProfileGrid();
	}

	public GrepSequenceJComboBox getHighlightSequenceBlank()
	{
		return highlightSequenceBlank;
	}

	public JComboBox getHighlightSequenceColorBlank()
	{
		return highlightSequenceColor;
	}

	public JRadioButton getSequenceRadioButton()
	{
		return sequenceRadioButton;
	}

	@Override
	public void keyReleased(KeyEvent e)
	{
		if(e.getSource() == highlightValuesJTextField)
		{
			profileGridPresenter.onHighlightTypeChanged();
			profileGridPresenter.updateTopProfileGrid();
		}
	}

	@Override
	public void keyPressed(KeyEvent e)
	{
	}

	@Override
	public void keyTyped(KeyEvent e)
	{
	}

	public JRadioButton getAboveRadioButton()
	{
		return aboveRadioButton;
	}

	public JRadioButton getEqualsRadioButton()
	{
		return equalsRadioButton;
	}

	public JRadioButton getBelowRadioButton()
	{
		return belowRadioButton;
	}

	public JPanel getHighlightValuesJPanel()
	{
		return highlightValuesJPanel;
	}

	public JPanel getHighlightSequenceJPanel()
	{
		return highlightSequenceJPanel;
	}

	public JTextField getHighlightValuesJTextField()
	{
		return highlightValuesJTextField;
	}

	public int getHighlightType()
	{
		return sequenceRadioButton.isSelected() ? 0 : 1;
	}

	public int getAboveEqualsOrBelow()
	{
		int aboveEqualsOrBelow = 0;

		if(equalsRadioButton.isSelected())
			aboveEqualsOrBelow = 1;
		if(belowRadioButton.isSelected())
			aboveEqualsOrBelow = 2;

		return aboveEqualsOrBelow;
	}

	public double getHighlightThreshold()
	{
		String threshold = highlightValuesJTextField.getText();

		try
		{
			return Double.parseDouble(threshold);

		}
		catch(NumberFormatException e)
		{
		}

		return 0.0;
	}
}
