package jprofilegrid.view.main;


import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import jprofilegrid.presenter.ProfileGridPresenter;

public class ExportJPanel extends JPanel implements ActionListener, KeyListener
{
    private static final long serialVersionUID = 8154981749436394738L;
    private JLabel columnsPerTierLabel =  new JLabel("Columns:"), formatLabel = new JLabel("Format:");
    private JButton outputFileBrowseButton = new JButton("Browse");
    private JTextField columnsPerTierBlank = new JTextField(String.valueOf(100), 4),
               outputFileBlank = new JTextField(1);
    private JButton exportButton = new JButton("Export");
    private JLabel rangeJLabel = new JLabel("  Range:");
    private JTextField startOfRange = new JTextField("1", 4);
    private JTextField endOfRange = new JTextField(4);
    private JLabel toLabel = new JLabel("to");
    private JComboBox fileTypeSelection = new JComboBox(new String[] {"Excel", "FASTA", "PNG", "PyMOL"});
    private JComboBox profileGridJComboBox = new JComboBox(new String[] {"Top", "Bottom"});
    //private boolean pyMOLDropDownJFrameIsHidden = true;
    //private PyMOLDropDownJFrame pyMOLDropDownJFrame;
    private JPanel columnsSelectionPanel = new JPanel();
    private ProfileGridPresenter profileGridPresenter;
    private JLabel profileGridJLabel = new JLabel("ProfileGrid: ");
    private String pdbFile = null;

    public ExportJPanel(ProfileGridPresenter profileGridPresenter)
    {
        this.profileGridPresenter = profileGridPresenter;
    }

    public void initializeExportPanel()
    {
        Border border = new LineBorder(new java.awt.Color(9, 0, 128), 1);
        TitledBorder exportPanelBorder = BorderFactory.createTitledBorder(border, "Export");
        exportPanelBorder.setTitleColor(new java.awt.Color(0, 0, 0));
        setBorder(exportPanelBorder);

        GridBagLayout exportPanelLayout = new GridBagLayout();
        GridBagConstraints exportPanelConstraints = new GridBagConstraints();
        setLayout(exportPanelLayout);

        exportPanelConstraints.fill = GridBagConstraints.HORIZONTAL;

        exportPanelConstraints.gridx = 0;
        exportPanelConstraints.gridy = 0;
        exportPanelConstraints.weightx = 0;
        exportPanelConstraints.gridwidth = 1;
        outputFileBrowseButton.addActionListener(this);
        add(outputFileBrowseButton, exportPanelConstraints);

        exportPanelConstraints.gridx = 1;
        exportPanelConstraints.weightx = 1;
        exportPanelConstraints.gridwidth = 2;
        add(outputFileBlank, exportPanelConstraints);

        exportPanelConstraints.fill = GridBagConstraints.NONE;
        exportPanelConstraints.gridx = 0;
        exportPanelConstraints.gridy = 1;
        exportPanelConstraints.weightx = 0;
        exportPanelConstraints.gridwidth = 1;
        add(formatLabel, exportPanelConstraints);

        exportPanelConstraints.gridx = 1;
        exportPanelConstraints.weightx = 1;
        exportPanelConstraints.anchor = GridBagConstraints.LINE_START;
        add(fileTypeSelection, exportPanelConstraints);

        columnsSelectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints columnSelectionConstraints = new GridBagConstraints();

        columnSelectionConstraints.weightx = 0;
        columnSelectionConstraints.weighty = 0;
        columnSelectionConstraints.gridx = 0;
        columnSelectionConstraints.gridy = 0;
        columnSelectionConstraints.fill = GridBagConstraints.BOTH;
        columnSelectionConstraints.anchor = GridBagConstraints.LINE_START;
        columnSelectionConstraints.gridwidth = 1;
        columnSelectionConstraints.gridheight = 1;
        columnsSelectionPanel.add(rangeJLabel, columnSelectionConstraints);

        startOfRange.setText(String.valueOf(1));
        columnSelectionConstraints.gridx++;
        columnSelectionConstraints.weightx = 1;
        columnsSelectionPanel.add(startOfRange, columnSelectionConstraints);

        columnSelectionConstraints.gridx++;
        columnsSelectionPanel.add(toLabel, columnSelectionConstraints);

        columnSelectionConstraints.gridx++;
        columnsSelectionPanel.add(endOfRange, columnSelectionConstraints);

        JPanel thirdExportRowJPanel = new JPanel(new GridBagLayout());
        GridBagConstraints thirdExportRowConstraints = new GridBagConstraints();

        exportPanelConstraints.gridx = 2;
        add(columnsSelectionPanel, exportPanelConstraints);

        thirdExportRowConstraints.gridx = 0;
        thirdExportRowConstraints.gridy = 0;
        thirdExportRowConstraints.fill = GridBagConstraints.NONE;

        thirdExportRowJPanel.add(columnsPerTierLabel, thirdExportRowConstraints);
        columnsPerTierLabel.setEnabled(false);

        thirdExportRowConstraints.gridx++;
        thirdExportRowJPanel.add(columnsPerTierBlank, thirdExportRowConstraints);
        columnsPerTierBlank.setEnabled(false);
        columnsPerTierBlank.addKeyListener(this);

        thirdExportRowConstraints.gridx++;
        thirdExportRowJPanel.add(profileGridJLabel, thirdExportRowConstraints);
        profileGridJLabel.setEnabled(false);

        thirdExportRowConstraints.gridx++;
        thirdExportRowJPanel.add(profileGridJComboBox, thirdExportRowConstraints);
        profileGridJComboBox.setEnabled(false);

        thirdExportRowConstraints.gridx++;
        thirdExportRowJPanel.add(exportButton, thirdExportRowConstraints);

        columnSelectionConstraints.gridx = 0;
        columnSelectionConstraints.gridy = 2;
        columnSelectionConstraints.gridwidth = 3;
        columnSelectionConstraints.gridheight = 2;
        add(thirdExportRowJPanel, columnSelectionConstraints);

        exportButton.addActionListener(this);
        exportButton.setEnabled(false);
        ProfileGridPresenter.setAllComponentsEnabled(false, columnsSelectionPanel);

        fileTypeSelection.addActionListener(this);
    }

    public int getColumnsPerTier()
    {
        try
        {
            return( Integer.parseInt(columnsPerTierBlank.getText()));
        }
        catch(NumberFormatException e)
        {
        }

        return 0;
    }

    public int getFirstColumn()
    {
        try
        {
            return( Integer.parseInt(startOfRange.getText()));
        }
        catch(NumberFormatException e)
        {
        }

        return 0;
    }

    public void setStartColumn(int nStartColumn)
    {
        startOfRange.setText(String.valueOf(nStartColumn));
    }

    public void setFinalColumn(int nFinalColumn)
    {
        endOfRange.setText(String.valueOf(nFinalColumn));
    }

    public int getLastColumn()
    {
        try
        {
            return( Integer.parseInt(endOfRange.getText()));
        }
        catch(NumberFormatException e)
        {
        }

        return 0;
    }

    public String getOutputFilename()
    {
        return(outputFileBlank.getText());
    }

    public void actionPerformed(ActionEvent e)
    {
        if( e.getSource() == exportButton )
        {
            int fileType = fileTypeSelection.getSelectedIndex();
            switch(fileType)
            {
                case 0: profileGridPresenter.outputExcelFile();   break;
                case 1: profileGridPresenter.outputFASTAFile();   break;
                case 2: profileGridPresenter.outputImageFile();   break;
                case 3: profileGridPresenter.outputPyMOLScript(); break;
            }
        }
        if( e.getSource() == outputFileBrowseButton )
        {
            profileGridPresenter.showSelectOutputFileDialog();
        }

        if( e.getSource() == fileTypeSelection )
        {
            if( fileTypeSelection.getSelectedIndex() == 0 )
            {
                outputFileBlank.setText(outputFileBlank.getText().substring(0, outputFileBlank.getText().length() - 3) + "xls");
                rangeJLabel.setEnabled(true);
                toLabel.setEnabled(true);
                startOfRange.setEnabled(true);
                endOfRange.setEnabled(true);
                columnsPerTierLabel.setEnabled(true);
                columnsPerTierBlank.setEnabled(true);
            }

            if( fileTypeSelection.getSelectedIndex() == 1 )
            {
                outputFileBlank.setText(outputFileBlank.getText().substring(0, outputFileBlank.getText().length() - 3) + "afa");
                columnsPerTierLabel.setEnabled(false);
                columnsPerTierBlank.setEnabled(false);
                 rangeJLabel.setEnabled(false);
                toLabel.setEnabled(false);
                startOfRange.setEnabled(false);
                endOfRange.setEnabled(false);
            }

            if( fileTypeSelection.getSelectedIndex() == 2 )
            {
                outputFileBlank.setText(outputFileBlank.getText().substring(0, outputFileBlank.getText().length() - 3) + "png");
                columnsPerTierLabel.setEnabled(false);
                columnsPerTierBlank.setEnabled(false);
                 rangeJLabel.setEnabled(false);
                toLabel.setEnabled(false);
                startOfRange.setEnabled(false);
                endOfRange.setEnabled(false);
            }

            if( fileTypeSelection.getSelectedIndex() ==  3)
            {
                // Whenever the user switches to the PyMOL Script mode, ask for PDB filename.
                final JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Please select PDB file");
                int fileSelected = jFileChooser.showDialog(this, "Select");
                if(fileSelected == JFileChooser.APPROVE_OPTION)
                {
                    File file = jFileChooser.getSelectedFile();
                    if(file != null)
                        try
                        {
                            pdbFile = file.getCanonicalPath();
                        } catch (IOException ioException)
                        {
                        }
                }

                outputFileBlank.setText(outputFileBlank.getText().substring(0, outputFileBlank.getText().length() - 3) + "pml");
                columnsPerTierLabel.setEnabled(false);
                columnsPerTierBlank.setEnabled(false);
            }

        }
    }

    public void setOutputFileType(int index)
    {
        fileTypeSelection.setSelectedIndex(index);
    }

    public JPanel getColumnsSelectionPanel()
    {
        return columnsSelectionPanel;
    }

    public void setOutputFilename( String nFilename )
    {
        outputFileBlank.setText(nFilename);
    }

    public void setDualDisplayEnabled(boolean enabled)
    {
        profileGridJLabel.setEnabled(enabled);
        profileGridJComboBox.setEnabled(enabled);

        if(!enabled)
            profileGridJComboBox.setSelectedIndex(0);
    }

    public int getSelectedProfileGrid()
    {
        return profileGridJComboBox.getSelectedIndex();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent)
    {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent)
    {
        if(keyEvent.getSource() == columnsPerTierBlank )
        {
            try
            {
                int numColumns = Integer.parseInt(columnsPerTierBlank.getText());

                if(numColumns > 0)
                    profileGridPresenter.updateTopProfileGrid();
            }
            catch(NumberFormatException numberFormatException)
            {
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled)
    {
        super.setEnabled(enabled);

        columnsPerTierLabel.setEnabled(enabled);
        columnsPerTierBlank.setEnabled(enabled);
        exportButton.setEnabled(enabled);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent)
    {
    }

    public JTextField getOutputFileBlank()
    {
        return outputFileBlank;
    }

    public String getPDBFile()
    {
        return pdbFile;
    }

}
