package jprofilegrid.view.main;


import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import jprofilegrid.presenter.ProfileGridPresenter;


public class FiltersJPanel extends JPanel implements ActionListener
{
	private static final long serialVersionUID = 4146127699838314762L;

	private JTextField speciesNameFilter = new JTextField(String.valueOf("")),
		sequenceFilter = new JTextField(String.valueOf(""));

	private JLabel[] parameterLabels = {new JLabel("Sequence Name:"), new JLabel("Sequence:")};
	private JComponent[] parameterBlanks = { speciesNameFilter, sequenceFilter };

	private String applyFilterButtonlabel = new String("Filter");
	private String optionsPanelTitle = new String("Regular Expression Filters");
	private JButton applyFilterButton = new JButton(applyFilterButtonlabel);

	private JLabel matches = new JLabel("No Matches");

	private JLabel filtersLabel = new JLabel("Regular Expression Filters: ");
	private JCheckBox filtersCheckBox = new JCheckBox();

	private ProfileGridPresenter profileGridPresenter;

	public FiltersJPanel(ProfileGridPresenter profileGridPresenter)
	{
		this.profileGridPresenter = profileGridPresenter;
	}

	public void actionPerformed(ActionEvent e)
	{
		if( e.getSource() == applyFilterButton )
			profileGridPresenter.onRegExFiltersChanged(speciesNameFilter.getText(), sequenceFilter.getText());

		if( e.getSource() == filtersCheckBox )
		{
			profileGridPresenter.onFilterchange();

			for( int i = 0; i < parameterLabels.length; i++ )
			{
				parameterLabels[i].setEnabled(filtersCheckBox.isSelected());
				parameterBlanks[i].setEnabled(filtersCheckBox.isSelected());
				applyFilterButton.setEnabled(filtersCheckBox.isSelected());
				matches.setEnabled(filtersCheckBox.isSelected());
			}
		}
	}

	public void initializeParametersPanel()
	{
		setLayout(new GridBagLayout());
		Border border = new LineBorder(new java.awt.Color(72, 61, 139), 1);
		TitledBorder optionsPanelBorder = BorderFactory.createTitledBorder(border, optionsPanelTitle);
		optionsPanelBorder.setTitleColor(new java.awt.Color(0,0,0));
		setBorder(optionsPanelBorder);
		GridBagConstraints constraints = new GridBagConstraints();
		sequenceFilter.setAlignmentX(JLabel.RIGHT_ALIGNMENT);
		setAlignmentX(JPanel.RIGHT_ALIGNMENT);
		applyFilterButton.addActionListener(this);
		applyFilterButton.setEnabled(false);
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.anchor = GridBagConstraints.LINE_END;

		constraints.gridwidth = 2;
		add(filtersLabel, constraints);
		constraints.gridwidth = 1;
		constraints.gridx = 2;
		constraints.anchor = GridBagConstraints.LINE_START;
		add(filtersCheckBox, constraints);

		constraints.gridx++;
		constraints.gridwidth = 2;
		constraints.anchor = GridBagConstraints.CENTER;
		add(matches,constraints);
		matches.setBackground(getBackground());
		matches.setVisible(false);

		constraints.gridy++;
		constraints.gridx = 0;
		filtersCheckBox.setSelected(true);
		filtersCheckBox.addActionListener(this);

		constraints.gridwidth = 1;
		constraints.weightx = 0;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		add(parameterLabels[0], constraints);
		constraints.gridx++;
		constraints.weightx = 1;
		constraints.gridwidth = 3;
		add(parameterBlanks[0], constraints);
		constraints.gridx = 0;
		constraints.gridy++;
		constraints.weightx = 0;
		constraints.gridwidth = 1;
		add(parameterLabels[1], constraints);
		constraints.gridx++;
		constraints.weightx = 1;
		constraints.gridwidth = 3;
		add(parameterBlanks[1], constraints);
		constraints.gridwidth = 1;
		constraints.gridx = 4;
		constraints.weightx = 0;
		constraints.gridy = 1;
		constraints.gridheight = 2;
		add(applyFilterButton, constraints);

	}


	public void enableProfileGridButton()
	{
		applyFilterButton.setEnabled(true);
	}

	public void disableProfileGridButton()
	{
		applyFilterButton.setEnabled(false);
	}

	public boolean getRegExFilteringEnabled()
	{
		return filtersCheckBox.isSelected();
	}
}

