package jprofilegrid.view.main;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import jprofilegrid.presenter.ProfileGridPresenter;

public class LoadAlignmentJPanel extends JPanel implements ActionListener
{
	private static final long serialVersionUID = -5232226079094194379L;
	private JButton browseButton = new JButton("Browse");
	private JButton loadFileButton = new JButton("Load");
	private JLabel typeOfMSALabel = new JLabel("Format:");
	private JTextField loadFileBlank = new JTextField(1);
	private JComboBox typeOfMSA = new JComboBox(new String[] {"MSF", "FASTA", "A2M", "Stockholm"});
	private JComboBox alignmentType = new JComboBox(new String[] {"Protein", "DNA"});
	private String filenameWithoutPath;
	private JTextArea numberOfSequences = new JTextArea();

	private ProfileGridPresenter profileGridPresenter;

	public LoadAlignmentJPanel(ProfileGridPresenter profileGridPresenter)
	{
		this.profileGridPresenter = profileGridPresenter;
	}

	public void initializeLoadMSAPanel()
	{
		Border border = new LineBorder(new java.awt.Color(178, 34, 34), 1);
		TitledBorder loadMSAPanelBorder = BorderFactory.createTitledBorder(border, "Load Alignment");
		loadMSAPanelBorder.setTitleColor(new java.awt.Color(0, 0, 0));
		setBorder(loadMSAPanelBorder);

		GridBagLayout loadMSAPanelLayout = new GridBagLayout();
		GridBagConstraints loadMSAPanelConstraints = new GridBagConstraints();
		loadFileButton.addActionListener(this);
		browseButton.addActionListener(this);
		loadMSAPanelConstraints.fill = GridBagConstraints.HORIZONTAL;
		loadMSAPanelConstraints.gridx = 0;
		loadMSAPanelConstraints.gridy = 0;
		loadMSAPanelConstraints.gridwidth = 1;

		setLayout(loadMSAPanelLayout);
		add(browseButton, loadMSAPanelConstraints);

		loadMSAPanelConstraints.weightx = 1;
		loadMSAPanelConstraints.gridx = 1;
		loadMSAPanelConstraints.gridwidth = 4;
		add(loadFileBlank, loadMSAPanelConstraints);

		loadMSAPanelConstraints.gridwidth = 1;
		loadMSAPanelConstraints.gridy = 1;
		loadMSAPanelConstraints.gridx = 4;
		loadMSAPanelConstraints.weightx = 0;
		loadMSAPanelConstraints.fill = GridBagConstraints.NONE;
		loadMSAPanelConstraints.anchor = GridBagConstraints.LINE_END;
		loadFileButton.setEnabled(false);
		add(loadFileButton, loadMSAPanelConstraints);

		loadMSAPanelConstraints.gridwidth = 1;
		loadMSAPanelConstraints.gridx = 0;
		loadMSAPanelConstraints.gridy = 1;
		loadMSAPanelConstraints.anchor = GridBagConstraints.CENTER;
		add(typeOfMSALabel, loadMSAPanelConstraints);

		loadMSAPanelConstraints.gridx = 1;
		add(typeOfMSA, loadMSAPanelConstraints);

		loadMSAPanelConstraints.gridx = 2;
		add(alignmentType, loadMSAPanelConstraints);

		loadMSAPanelConstraints.gridwidth = 1;
		loadMSAPanelConstraints.gridx = 3;
		loadMSAPanelConstraints.anchor = GridBagConstraints.CENTER;
		numberOfSequences.setVisible(false);
		numberOfSequences.setBackground(getBackground());
		add(numberOfSequences, loadMSAPanelConstraints);

		alignmentType.addActionListener(this);
	}

	public void actionPerformed( ActionEvent e )
	{
		if( e.getSource() == browseButton )
			profileGridPresenter.browseForMSAFile();
		if( e.getSource() == loadFileButton )
		{
			loadFileButton.setEnabled(false);
			profileGridPresenter.performLoad();
		}
	}
	public String getFilename()
	{
		return( loadFileBlank.getText() );
	}

	public void setFilenameWithoutPath(String nFilenameWithoutPath)
	{
		filenameWithoutPath = nFilenameWithoutPath;
	}

	public String getFilenameWithoutPath()
	{
		return filenameWithoutPath;
	}

	public int getTypeOfMSA()
	{
		return( typeOfMSA.getSelectedIndex() );
	}

	public int getAlignmentType()
	{
		return(alignmentType.getSelectedIndex());
	}

	public JTextField getLoadFileBlank()
	{
		return loadFileBlank;
	}

	public JButton getLoadFileButton()
	{
		return loadFileButton;
	}
}