package jprofilegrid.view.main;


import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.GridBagConstraintsInitializer;
import jprofilegrid.view.OpenWindowsMenu;
import jprofilegrid.view.gridparameters.GridParametersJPanel;

public class MainJFrame extends JFrame implements ActionListener
{
    private static final long serialVersionUID = -2882870135254599572L;

    GridBagLayout layout = new GridBagLayout();
    GridBagConstraints constraints = new GridBagConstraints();

    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File"),
                 aboutMenu = new Menu("About");
    private OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
    private MenuItem aboutMenuItem = new MenuItem("JProfileGrid"),
                     quitMenuItem  = new MenuItem("Quit");

    private LoadAlignmentJPanel loadAlignmentJPanel;
    private GridParametersJPanel gridParametersJPanel;
    private FiltersJPanel filtersJPanel;
    private SimilarityParametersJPanel similarityParametersJPanel;
    private ExportJPanel exportJPanel;

    static
    {
        try { UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()); }
        catch (InstantiationException e) {}
        catch (ClassNotFoundException e) {}
        catch (UnsupportedLookAndFeelException e) {}
        catch (IllegalAccessException e) {}
    }

    public MainJFrame(ProfileGridPresenter profileGridPresenter)
    {
        super("JProfileGrid");

        loadAlignmentJPanel = new LoadAlignmentJPanel(profileGridPresenter);
        gridParametersJPanel = new GridParametersJPanel(profileGridPresenter);
        filtersJPanel = new FiltersJPanel(profileGridPresenter);
        similarityParametersJPanel = new SimilarityParametersJPanel(profileGridPresenter);
        exportJPanel = new ExportJPanel(profileGridPresenter);

        setMenuBar(menuBar);
        menuBar.add(fileMenu);

        addWindowListener(openWindowsMenu);

        menuBar.add(openWindowsMenu);
        menuBar.add(aboutMenu);
        quitMenuItem.addActionListener(this);
        aboutMenu.add(aboutMenuItem);
        aboutMenuItem.addActionListener(this);
        fileMenu.add(quitMenuItem);

        displayWindow();
        pack();
    }

    public void displayWindow()
    {
        initializeConstantValues();
        initializeJPanels();

        pack();

        setVisible(true);
    }

    private void initializeConstantValues()
    {
        setLocation(25, 25);
        setResizable(false);
        setDefaultCloseOperation(EXIT_ON_CLOSE);
    }

    private void initializeJPanels()
    {
        loadAlignmentJPanel.initializeLoadMSAPanel();
        filtersJPanel.initializeParametersPanel();
        similarityParametersJPanel.initializeParametersPanel();
        exportJPanel.initializeExportPanel();
        gridParametersJPanel.initializeAnalyzePanel();

        // Disable options until load.
        ProfileGridPresenter.setAllComponentsEnabled(false, similarityParametersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(false, gridParametersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(false, gridParametersJPanel.getPositionRulerJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, gridParametersJPanel.getFrequencyColorsJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, gridParametersJPanel.getSortAndDualDisplayJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, gridParametersJPanel.getOverviewTypesJPanel());
        ProfileGridPresenter.setAllComponentsEnabled(false, filtersJPanel);
        ProfileGridPresenter.setAllComponentsEnabled(false, exportJPanel);

        constraints.fill = GridBagConstraints.BOTH;
        constraints.anchor = GridBagConstraints.CENTER;

        constraints.gridx = 0;
        constraints.gridy = 0;

        setLayout(layout);
        add(loadAlignmentJPanel, constraints);
        constraints.gridy++;
        add(gridParametersJPanel, constraints);
        constraints.gridy++;
        add(filtersJPanel, constraints);
        constraints.gridy++;
        add(similarityParametersJPanel, constraints);
        constraints.gridy++;
        add(exportJPanel, constraints);
    }

    public LoadAlignmentJPanel getLoadAlignmentPanel()
    {
        return loadAlignmentJPanel;
    }

    public SimilarityParametersJPanel getSimilarityParametersPanel()
    {
        return similarityParametersJPanel;
    }

    public GridParametersJPanel getGridParametersPanel()
    {
        return gridParametersJPanel;
    }

    public ExportJPanel getExportPanel()
    {
        return exportJPanel;
    }

    public FiltersJPanel getFiltersPanel()
    {
        return filtersJPanel;
    }

    public void actionPerformed(ActionEvent event)
    {
        if( event.getSource() == quitMenuItem )
            System.exit(0);
        if( event.getSource() == aboutMenuItem )
            showAboutDialog();
    }

    public void showAboutDialog()
    {
        JPanel aboutJPanel = new JPanel();
        aboutJPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraintsInitializer.resetConstraints(constraints);

        constraints.insets = new Insets(0,10,2,10);
        // TODO update version & date
        // TODO update citation
        JLabel rowOne = new JLabel("JProfileGrid v2.0.5; January 17th, 2013");
        rowOne.setHorizontalAlignment(JLabel.CENTER);
        JLabel rowTwo = new JLabel("http://www.ProfileGrid.org");
        rowTwo.setHorizontalAlignment(JLabel.CENTER);
        JTextArea rowThree = new JTextArea("Cite publication: A.I.Roca, A.C.Abajian, D.J.Vigerust. ProfileGrids solve the\n" +
                "large alignment visualization problem: influenza hemeagglutinin example.\n" +
                "F1000Research 2:2 (2013)");
        rowThree.setBackground(getBackground());
        rowThree.setEditable(false);
        JTextArea rowFive = new JTextArea("The ProfileGrid representation is in the public domain if others\n" +
        		"wish to code their own implementations.");
        rowFive.setBackground(getBackground());
        rowFive.setFont(new Font(rowFive.getFont().getName(), Font.BOLD, rowFive.getFont().getSize()));
        rowFive.setEditable(false);
        JTextArea rowSix = new JTextArea("Copyright (c) 2012 ProfileGrid.org\n" +
        		"This program is free software: you can redistribute it and/or modify\n" +
        		"it under the terms of the GNU General Public License as published by\n" +
        		"the Free Software Foundation, either version 3 of the License, or\n" +
        		"(at your option) any later version.\n\n" +
        		"This program is distributed in the hope that it will be useful,\n" +
        		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" +
        		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n" +
        		"GNU General Public License for more details.\n\n" +
        		"You should have received a copy of the GNU General Public License\n" +
        		"along with this program. If not, see http://www.gnu.org/licenses/.");
        rowSix.setBackground(getBackground());
        rowSix.setEditable(false);
        aboutJPanel.add(rowOne, constraints);
        constraints.gridy++;
        constraints.insets = new Insets(0,10,10,10);
        aboutJPanel.add(rowTwo, constraints);
        constraints.insets = new Insets(0,10,2,10);
        constraints.gridy++;
        constraints.anchor = GridBagConstraints.LINE_START;
        aboutJPanel.add(rowThree, constraints);
        constraints.insets = new Insets(10,10,2,10);
        constraints.gridy++;
        aboutJPanel.add(rowFive, constraints);
        constraints.gridy++;
        aboutJPanel.add(rowSix, constraints);
        aboutJPanel.setBackground(getBackground());
        JDialog aboutDialog = new JDialog(this, "About");

        aboutDialog.add(aboutJPanel);
        aboutDialog.pack();
        aboutDialog.setLocation(getX() + (getWidth() - aboutDialog.getWidth()) / 2, getY());
        aboutDialog.setResizable(false);

        aboutDialog.setVisible(true);
    }
}
