package jprofilegrid.view.main;


import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import jprofilegrid.presenter.ProfileGridPresenter;


public class SimilarityParametersJPanel extends JPanel implements ActionListener
{
	private static final long serialVersionUID = -8577716065919949185L;

	private EnableSimilaritiesJPanel enableSimilaritiesJPanel = new EnableSimilaritiesJPanel();

	private JTextField windowSizeBlank = new JTextField(String.valueOf(5)),
		thresholdBlank = new JTextField(String.valueOf(.7));

	private JComponent[] parameterBlanks = { windowSizeBlank, thresholdBlank };

	private JLabel[] parameterLabels = {new JLabel("Window Size:" ),
										new JLabel("Threshold:" )};

	private String computeProfileGridString = new String("Compute");
	private String optionsPanelTitle = new String("Similarity Parameters");
	private JButton computeProfileGridButton = new JButton(computeProfileGridString);

	private ProfileGridPresenter profileGridPresenter;

	public SimilarityParametersJPanel(ProfileGridPresenter profileGridPresenter)
	{
		this.profileGridPresenter = profileGridPresenter;
	}

	public void actionPerformed(ActionEvent e)
	{
		if( e.getSource() == computeProfileGridButton )
		{
			computeProfileGridButton.setEnabled(false);
			computeProfileGridButton.setText("Computing");
			profileGridPresenter.computeSimilarityParameters();
		}
	}

	public boolean currentlyComputing()
	{
		return computeProfileGridButton.getText().equalsIgnoreCase("Computing");
	}

	public void setSimilarityComputationButtonDone()
	{
		computeProfileGridButton.setEnabled(true);
		computeProfileGridButton.setText("Compute");
	}

	public int getWindowSize()
	{
		return Integer.parseInt(windowSizeBlank.getText());
	}

	public Double getThreshold()
	{
		return Double.parseDouble(thresholdBlank.getText());
	}

	public boolean similarityParametersEnabled()
	{
		return enableSimilaritiesJPanel.similarityParametersEnabled();
	}

	public EnableSimilaritiesJPanel getEnabledSimilaritiesJPanel()
	{
		return enableSimilaritiesJPanel;
	}

	public void initializeParametersPanel()
	{
		setLayout(new GridBagLayout());
		Border border = new LineBorder(new java.awt.Color(218, 165, 32), 1);
		TitledBorder optionsPanelBorder = BorderFactory.createTitledBorder(border, optionsPanelTitle);
		optionsPanelBorder.setTitleColor(new java.awt.Color(0,0,0));
		setBorder(optionsPanelBorder);
		GridBagConstraints constraints = new GridBagConstraints();
		computeProfileGridButton.addActionListener(this);

		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.gridwidth = 5;

		constraints.anchor = GridBagConstraints.LINE_START;
		add(enableSimilaritiesJPanel, constraints);

		constraints.gridy++;

		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.insets = new Insets(2,2,2,2);
		constraints.anchor = GridBagConstraints.CENTER;
		constraints.gridwidth = 1;
		constraints.weightx = 0;


		constraints.fill = GridBagConstraints.HORIZONTAL;
		add(parameterLabels[0], constraints);
		constraints.gridx++;

		constraints.weightx = 1;
		add(parameterBlanks[0], constraints);
		constraints.gridx++;

		constraints.weightx = 0;
		constraints.gridwidth = 1;
		add(parameterLabels[1], constraints);
		constraints.gridx+=1;
		constraints.gridwidth = 1;
		constraints.weightx = 1;
		add(parameterBlanks[1], constraints);
		constraints.gridx++;
		constraints.weightx = 0;
		add(computeProfileGridButton, constraints);
		ProfileGridPresenter.setAllComponentsEnabled(false, enableSimilaritiesJPanel);
	}

	public void enableComputeSimilarityParametersButton()
	{
		computeProfileGridButton.setText("Compute");
		computeProfileGridButton.setEnabled(true);
	}

	public void disableComputeProfileGridButton()
	{
		computeProfileGridButton.setEnabled(false);
	}

	private class EnableSimilaritiesJPanel extends JPanel implements ActionListener
	{
		private static final long serialVersionUID = 6235369997098867396L;

		private JLabel enableSimilarityParametersJLabel = new JLabel("Show Similarity Parameters:"),
					   fractionOfSequencesJLabel		= new JLabel("Fraction of Sequences:");

		private JCheckBox enableSimilarityParametersJCheckBox = new JCheckBox();

		private JTextField fractionOfSequencesJTextField = new JTextField("1.00", 3);

		public EnableSimilaritiesJPanel()
		{
			initializeComponents();
		}

		private void initializeComponents()
		{
			setLayout(new GridBagLayout());
			GridBagConstraints constraints = new GridBagConstraints();
			constraints.gridy = 0;
			constraints.gridx = 0;

			constraints.anchor = GridBagConstraints.CENTER;
			add(enableSimilarityParametersJLabel, constraints);
			constraints.gridx++;
			add(enableSimilarityParametersJCheckBox, constraints);
			enableSimilarityParametersJCheckBox.setSelected(true);
			enableSimilarityParametersJCheckBox.addActionListener(this);

			constraints.gridx++;
			add(fractionOfSequencesJLabel, constraints);
			constraints.gridx++;
			add(fractionOfSequencesJTextField, constraints);
		}

		public void actionPerformed(ActionEvent event)
		{
			if(event.getSource() == enableSimilarityParametersJCheckBox)
			{
				boolean similarityParametersEnabled = enableSimilarityParametersJCheckBox.isSelected();
				fractionOfSequencesJLabel.setEnabled(similarityParametersEnabled);
				fractionOfSequencesJTextField.setEnabled(similarityParametersEnabled);
				for(int i = 0; i < parameterBlanks.length; i++)
				{
					parameterBlanks[i].setEnabled(similarityParametersEnabled);
					parameterLabels[i].setEnabled(similarityParametersEnabled);
					computeProfileGridButton.setEnabled(similarityParametersEnabled);
				}

				profileGridPresenter.updateTopProfileGrid();
			}
		}

		public boolean similarityParametersEnabled()
		{
			return enableSimilarityParametersJCheckBox.isSelected();
		}

		public double getSimilarityFraction()
		{
			try
			{
				return Math.abs(Double.parseDouble(fractionOfSequencesJTextField.getText()));
			}
			catch(NumberFormatException nfe)
			{
				return 1.00;
			}
		}
	}

	@Override
	public void setEnabled(boolean enabled)
	{
		super.setEnabled(enabled);
		ProfileGridPresenter.setAllComponentsEnabled(enabled, enableSimilaritiesJPanel);
	}

	public double getSimilarityFraction()
	{
		return enableSimilaritiesJPanel.getSimilarityFraction();
	}
}

