package jprofilegrid.view.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class MetaData
{
	private static final short META_DATA_TYPES_ROW = 0;
	private static final short SEQUENCE_NAMES_COLUMN = 0;

	private HashMap<String, MetaDataType> metaDataTypesByName = new HashMap<String, MetaDataType>();
	private HashMap<String, HashMap<String, String>> sequenceMetaData = new HashMap<String, HashMap<String, String>>();

	public HashMap<String, String> getMetaDataForSequence(String sequenceName)
	{
		return sequenceMetaData.get(sequenceName);
	}

	public Collection<String> getMetaDataTypesByColumn()
	{
		return metaDataTypesByName.keySet();
	}

	public List<String> getMetaDataValuesOfType(String metaDataType)
	{
		if(metaDataType == null)
			return null;

		return metaDataTypesByName.get(metaDataType).getValues();
	}

	public List<String> getSequencesWithMetaDataTypeMatching(Object metaDataType, Object[] metaDataValues)
	{
		List<String> matchingSequences = new ArrayList<String>();

		if(metaDataType != null && metaDataValues != null)
			for(String sequence : sequenceMetaData.keySet())
			{
				HashMap<String, String> metaData = sequenceMetaData.get(sequence);

				String value = metaData.get(metaDataType);

				for(Object metaDataValue : metaDataValues)
					if(metaDataValue.equals(value))
						matchingSequences.add(sequence);
			}

		return matchingSequences;
	}

	public MetaData(String metaDataFilename) throws BiffException, IOException
	{
		if(metaDataFilename == null || metaDataFilename.isEmpty())
			return;

		File metaDataFile = new File(metaDataFilename);

		Workbook metaDataWorkbook = null;

		metaDataWorkbook = Workbook.getWorkbook(metaDataFile);

		if(metaDataWorkbook != null && metaDataWorkbook.getNumberOfSheets() > 0)
		{
			Sheet metaDataSheet = metaDataWorkbook.getSheet(0);

			int rows = metaDataSheet.getRows();
			int cols = metaDataSheet.getColumns();

			List<String> sequenceNamesByRow = new ArrayList<String>();
			List<String> metaDataTypesByColumn = new ArrayList<String>();

			for(int row = 0; row < rows; row++)
				for(int col = 0; col < cols; col++)
				{
					Cell cell = metaDataSheet.getCell(col, row);

					if(cell != null)
					{
						String content = cell.getContents();

						if(content != null && !content.isEmpty())
							if(row == META_DATA_TYPES_ROW)
							{
								metaDataTypesByColumn.add(content);
								metaDataTypesByName.put(content, new MetaDataType());
							}
							else
							{
								if(col == SEQUENCE_NAMES_COLUMN)
								{
									sequenceNamesByRow.add(content);
									sequenceMetaData.put(content, new HashMap<String, String>());
								}

								String metaDataType = metaDataTypesByColumn.get(col);
								String sequenceName = sequenceNamesByRow.get(row - 1);

								metaDataTypesByName.get(metaDataType).addValue(content);
								sequenceMetaData.get(sequenceName).put(metaDataType, content);
							}
					}
				}
		}
	}
}
