package jprofilegrid.view.metadata;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import jprofilegrid.presenter.ProfileGridPresenter;

public class MetaDataColumnJPanel extends JPanel implements ListSelectionListener
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private JList metaDataTypesJList = new JList(),
				  metaDataValuesJList = new JList(),
				  matchingSequencesJList = new JList();

	private MetaData metaData;

	private ProfileGridPresenter profileGridPresenter;

	public MetaDataColumnJPanel(ProfileGridPresenter profileGridPresenter, String label, MetaData metaData)
	{
		this.profileGridPresenter = profileGridPresenter;
		this.metaData = metaData;

		Collection<String> metaDataTypes = metaData.getMetaDataTypesByColumn();

		metaDataTypesJList.setModel(new CollectionListModel(metaDataTypes));

		setupLayout();

		metaDataTypesJList.addListSelectionListener(this);
		metaDataTypesJList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		metaDataValuesJList.addListSelectionListener(this);
		metaDataValuesJList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

		matchingSequencesJList.setEnabled(false);
	}

	private class CollectionListModel extends DefaultListModel
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public CollectionListModel(Collection<String> listData)
		{
			// Does this data consist of numbers or text?
			Queue<MetaDataValue> sorter = new PriorityQueue<MetaDataValue>();
			Iterator<String> dataIterator = listData.iterator();
			while(dataIterator.hasNext())
				sorter.add(new MetaDataValue(dataIterator.next()));

			while(!sorter.isEmpty())
				addElement(sorter.remove().getSValue());
		}
	}

	private void setupLayout()
	{
		setLayout(new GridBagLayout());

		GridBagConstraints gbc = new GridBagConstraints();

		gbc.insets = new Insets(5, 5, 5, 5);
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.anchor = GridBagConstraints.CENTER;

		add(new Label("Choose Meta Data Type"), gbc);
		gbc.gridy++;

		add(new ColumnJScrollPane(metaDataTypesJList), gbc);
		gbc.gridx = 1;
		gbc.gridy = 0;

		add(new Label("Choose Meta Data Value"), gbc);
		gbc.gridy++;

		add(new ColumnJScrollPane(metaDataValuesJList), gbc);
		gbc.gridx = 2;
		gbc.gridy = 0;

		add(new Label("Matching Sequences"), gbc);
		gbc.gridy++;
		add(new ColumnJScrollPane(matchingSequencesJList), gbc);
	}

	@Override
	public void valueChanged(ListSelectionEvent listSelectionEvent)
	{
		Object source = listSelectionEvent.getSource();
		if(!listSelectionEvent.getValueIsAdjusting())
		{
			if(source == metaDataTypesJList)
			{
				List<String> metaDataTypeValues = metaData.getMetaDataValuesOfType((String)metaDataTypesJList.getSelectedValue());

				metaDataValuesJList.setModel(new CollectionListModel(metaDataTypeValues));
			}

			if(source == metaDataValuesJList)
			{
				List<String> matchingSequences = metaData.getSequencesWithMetaDataTypeMatching(metaDataTypesJList.getSelectedValue(),
																				 			   metaDataValuesJList.getSelectedValues());

				matchingSequencesJList.setModel(new CollectionListModel(matchingSequences));

				profileGridPresenter.onMetaDataFilterChanged(matchingSequences);
			}
		}
	}
}
