package jprofilegrid.view.metadata;

import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

import jprofilegrid.presenter.ProfileGridPresenter;

public class MetaDataColumnsJFrame extends JFrame
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private List<JScrollPane> metaDataColumnJScrollPanes = new ArrayList<JScrollPane>();
	private ProfileGridPresenter profileGridPresenter;

	public MetaDataColumnsJFrame(ProfileGridPresenter profileGridPresenter)
	{
		super("Meta Data Columns");
		this.profileGridPresenter = profileGridPresenter;
		setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		pack();
		setupLayout();
	}

	private void setupLayout()
	{
		setLayout(new GridBagLayout());
		setResizable(false);
	}

	public void addMetaDataColumnJPanel(MetaDataColumnJPanel metaDataColumnJPanel)
	{
		metaDataColumnJScrollPanes.add(new JScrollPane(metaDataColumnJPanel));
		reloadMetaDataColumnJPanels();
	}

	public void removeAllColumns()
	{
		for(JScrollPane metaDataColumnJScrollPane : metaDataColumnJScrollPanes)
			remove(metaDataColumnJScrollPane);

		metaDataColumnJScrollPanes.clear();
	}

	private void reloadMetaDataColumnJPanels()
	{
		GridBagConstraints gbc = new GridBagConstraints();

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.anchor = GridBagConstraints.CENTER;

		for(JScrollPane metaDataColumnJScrollPane : metaDataColumnJScrollPanes)
		{
			add(metaDataColumnJScrollPane, gbc);
			gbc.gridx++;
		}

		pack();
	}

	public void showMetaDataFileSelectionDialog()
	{
		FileDialog fileDialog = new FileDialog(this, "Select Meta Data Excel File", FileDialog.LOAD);
		fileDialog.setVisible(true);

		if(fileDialog.getFile() == null)
			return;

		String metaDataFilename = fileDialog.getDirectory() + fileDialog.getFile();
		loadMetaDataFromFile(metaDataFilename);
	}

	private void loadMetaDataFromFile(String metaDataFilename)
	{
		try
		{
			final MetaData metaData = new MetaData(metaDataFilename);

			final MetaDataColumnJPanel metaDataColumnJPanel = new MetaDataColumnJPanel(profileGridPresenter, "Choose Meta Data Column", metaData);

			removeAllColumns();

			addMetaDataColumnJPanel(metaDataColumnJPanel);
			setVisible(true);
		}
		catch(Exception e)
		{
			setVisible(false);
			JOptionPane.showMessageDialog(new JFrame(), "Invalid metadata file format.", "Invalid Metadata File", JOptionPane.ERROR_MESSAGE);
		}
	}
}
