package jprofilegrid.view.metadata;

public class MetaDataValue implements Comparable<MetaDataValue>
{
	private String sValue;
	private Double dValue;
	private boolean isNumeric;

	public MetaDataValue(String value)
	{
		sValue = value;

		try
		{
			dValue = Double.parseDouble(sValue);
			isNumeric = true;
		}
		catch(NumberFormatException numberFormatException)
		{
			isNumeric = false;
		}
	}

	public boolean isNumeric()
	{
		return isNumeric;
	}

	public String getSValue()
	{
		return sValue;
	}

	public Double getDValue()
	{
		return dValue;
	}

	@Override
	public int compareTo(MetaDataValue metaDataValue)
	{
		if(isNumeric && metaDataValue.isNumeric())
			return dValue.compareTo(metaDataValue.getDValue());

		return sValue.compareTo(metaDataValue.getSValue());
	}
}
