package jprofilegrid.view.overview;

import java.awt.GridLayout;

import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import jprofilegrid.presenter.ProfileGridPresenter;

public class AlignmentOverviewJPanel extends JPanel
{
	private static final long serialVersionUID = -6107154041665201540L;


	private TableModel tableModel;
	private JTable jtable;

	public AlignmentOverviewJPanel(ProfileGridPresenter profileGridPresenter)
	{
		this.tableModel = profileGridPresenter.constructAlignmentOverviewTableModel();
		setLayout(new GridLayout(1,1));
		setOpaque(true);
	}

	public void resetDisplay()
	{
		removeAll();

		jtable = new JTable(tableModel);

		jtable.getTableHeader().setReorderingAllowed(false);
		jtable.setDragEnabled(false);
		jtable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		jtable.setCellSelectionEnabled(false);

		int cols = tableModel.getColumnCount();

		jtable.setDefaultRenderer(Object.class, new AlignmentOverviewTableCellRenderer());
		jtable.setShowGrid(false);

		jtable.setRowHeight(1);
		jtable.setRowMargin(0);

		for(int i = 0; i < cols; i++)
		{
			TableColumnModel tableColumnModel = jtable.getColumnModel();
			tableColumnModel.setColumnMargin(0);

			TableColumn tableColumn = tableColumnModel.getColumn(i);

			tableColumn.setMinWidth(1);
			tableColumn.setMaxWidth(1);
			tableColumn.setPreferredWidth(1);
			tableColumn.setWidth(1);
			tableColumn.setResizable(true);
		}

		add(jtable);

		repaint();
	}
}