package jprofilegrid.view.overview;

import java.awt.BorderLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;

import jprofilegrid.model.ProfileGrid;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.OpenWindowsMenu;

public class OverviewJFrame extends JFrame implements ActionListener
{
	private static final long serialVersionUID = -8447430469987480465L;

	private AlignmentOverviewJPanel alignmentOverviewJPanel;

	private OverviewJPanel overviewJPanel = new OverviewJPanel();

	private MenuBar menuBar = new MenuBar();
	private Menu fileMenu = new Menu("File");
	private Menu aboutMenu = new Menu("About");

	private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
	private MenuItem quitMenuItem = new MenuItem("Quit");

	private ProfileGridPresenter profileGridPresenter;

	public OverviewJFrame(ProfileGridPresenter profileGridPresenter, String title)
	{
		super(title);
		this.profileGridPresenter = profileGridPresenter;
		alignmentOverviewJPanel = new AlignmentOverviewJPanel(profileGridPresenter);
		setLayout(new BorderLayout());
		add(overviewJPanel, BorderLayout.NORTH);
		setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);

		initializeMenuBar();
		pack();
	}

	private void initializeMenuBar()
	{
		menuBar.add(fileMenu);
		OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
		addWindowListener(openWindowsMenu);
		menuBar.add(openWindowsMenu);
		menuBar.add(aboutMenu);
		quitMenuItem.addActionListener(this);
		aboutMenu.add(aboutMenuItem);
		aboutMenuItem.addActionListener(this);
		fileMenu.add(quitMenuItem);
		setMenuBar((menuBar));
	}

	public void resetDisplay(ProfileGrid profileGrid)
	{
		overviewJPanel.resetDisplay(profileGrid);
		alignmentOverviewJPanel.resetDisplay();
		pack();
	}

	public void displayProfileGridOverview(ProfileGrid profileGrid)
	{
		remove(alignmentOverviewJPanel);
		add(overviewJPanel, BorderLayout.NORTH);
		resetDisplay(profileGrid);
	}

	public void displayAlignmentOverview(int columnsPerTier, ProfileGrid profileGrid)
	{
		remove(overviewJPanel);
		add(alignmentOverviewJPanel, BorderLayout.NORTH);
		resetDisplay(profileGrid);
	}

	public void actionPerformed(ActionEvent event)
	{
		if( event.getSource() == quitMenuItem )
			System.exit(0);
		if( event.getSource() == aboutMenuItem )
		{
			profileGridPresenter.showAboutDialog();
			return;
		}
	}
}
