	package jprofilegrid.view.overview;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableColumnModel;

import jprofilegrid.model.AnalysisOptions;
import jprofilegrid.model.Cell;
import jprofilegrid.model.Format;
import jprofilegrid.model.ProfileGrid;
import jprofilegrid.model.Text;
import jprofilegrid.view.profilegrid.FixedAAColumnInTable;
import jprofilegrid.view.profilegrid.ProfileGridTableModel;

public class OverviewJPanel extends JPanel
{
	private static final long serialVersionUID = 8810051498829113732L;

	private ArrayList<ProfileGridTableModel> profileGridTableModels;
	private ArrayList<JTable> profileGridJTables;

	private JScrollPane jscrollPane;
	private JPanel nestedPanel = new JPanel();

	private ProfileGridTableModel symbolSideBarsData;

	public OverviewJPanel()
	{
		setLayout(new GridLayout2(0,1));
		setOpaque(true);
	}

	public void resetDisplayedData(ProfileGrid profileGrid)
	{
		int sequenceColumnOffset = 0;
		nestedPanel.setLayout(new GridLayout2(profileGridJTables.size() + 1, 1));
		for(int i = 0; i < profileGridJTables.size(); i++)
		{
			ProfileGridTableModel profileGridTableModel = profileGridTableModels.get(i);
			JTable profileGridJTable = profileGridJTables.get(i);

			int columnCount = profileGridTableModel.getColumnCount();
			AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
			int numberOfRows = analysisOptions.alignmentConstants.getNames().length;

			Cell[][] aminoAcidCounts = profileGrid.getEntireAlignment().getAminoAcidCounts();

			for( int j = 0; j < columnCount; j++ )
			{
				for( int k = 0; k < numberOfRows; k++ )
					profileGridTableModel.setValueAt(aminoAcidCounts[sequenceColumnOffset][k], k, j );

				sequenceColumnOffset++;
			}

			for(int j = 0; j < profileGridJTable.getColumnCount(); j++ )
			{
				profileGridJTable.getColumnModel().getColumn(j).setMinWidth(5);
				profileGridJTable.getColumnModel().getColumn(j).setMaxWidth(5);
				profileGridJTable.getColumnModel().getColumn(j).setPreferredWidth(5);
			}

			profileGridJTable.setRowHeight(5);
		}
		repaint();
	}

	public void resetDisplay(ProfileGrid profileGrid)
	{
		int numColumns = profileGrid.getAnalysisOptions().columnsPerTier;
		nestedPanel.removeAll();

		// First we must calculate how many rows, each with numColumns columns, we will have.
		int totalNumberOfAminoAcids = profileGrid.getEntireAlignment().getAminoAcidCounts().length;
		int numRows = (int)Math.ceil(totalNumberOfAminoAcids / (double)numColumns);
		int leftOverColumns = totalNumberOfAminoAcids - (numColumns * (numRows - 1));

		// Next we must create a table for each row, initialized to the correct number of amino acids.

		AnalysisOptions analysisOptions = profileGrid.getAnalysisOptions();
		int numAminoAcids = analysisOptions.alignmentConstants.getNames().length;
		profileGridTableModels = new ArrayList<ProfileGridTableModel>();
		profileGridJTables = new ArrayList<JTable>();
		for(int i = 0; i < numRows; i++)
		{
			int numColumnsInRow = numColumns;
			if(i == numRows - 1 && leftOverColumns > 0)
				numColumnsInRow = leftOverColumns;

			ProfileGridTableModel profileGridTableModel = new ProfileGridTableModel(numAminoAcids, numColumnsInRow);
			profileGridTableModels.add(profileGridTableModel);
			JTable profileGridJTable = new JTable(profileGridTableModel);

			profileGridJTable.getTableHeader().setReorderingAllowed(false);
			profileGridJTable.setDragEnabled(false);
			profileGridJTable.setGridColor(java.awt.Color.LIGHT_GRAY);
			profileGridJTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			profileGridJTable.setCellSelectionEnabled(false);
			profileGridJTable.setDefaultRenderer(Cell.class, new ProfileGridTableCellRenderer());
			profileGridJTable.setShowGrid(false);

			profileGridJTables.add(profileGridJTable);

			// Reset the information associated with the symbol side bars.
			String[] aas = profileGrid.getSortedAminoAcidSymbols();
			symbolSideBarsData = new ProfileGridTableModel(aas.length, 1);

			for(int j = 0; j < aas.length; j++)
				symbolSideBarsData.setValueAt(new Text(new Format(Format.CENTER_ALIGNED,Format.BOLD), aas[j]) , j, 0);

			JTable symbolSideBarsJTable = new JTable(symbolSideBarsData);
			symbolSideBarsJTable.getTableHeader().setReorderingAllowed(false);
			symbolSideBarsJTable.setColumnSelectionAllowed(false);
			symbolSideBarsJTable.setRowSelectionAllowed(false);
			symbolSideBarsJTable.setCellSelectionEnabled(false);
			symbolSideBarsJTable.setSize(5, 105);
			symbolSideBarsJTable.setPreferredSize(new Dimension(5, 105));
			symbolSideBarsJTable.setRowMargin(0);
			symbolSideBarsJTable.setRowHeight(5);

			int sortType = analysisOptions.sortType;
			String sortTypeName = analysisOptions.alignmentConstants.getSortTypes()[sortType];
			symbolSideBarsJTable.setDefaultRenderer(Text.class, new FixedAAColumnInTable(sortTypeName.equalsIgnoreCase("Taylor"), false));

			TableColumnModel symbolSideBarsTableColumnModel = symbolSideBarsJTable.getColumnModel();
			symbolSideBarsTableColumnModel.setColumnMargin(0);


			JPanel jpanel = new JPanel();
			jpanel.setLayout(new FlowLayout());
			jpanel.add(symbolSideBarsJTable);
			jpanel.add(profileGridJTable);

			nestedPanel.add(jpanel);
			JSeparator separator = new JSeparator(SwingConstants.VERTICAL);
			separator.setPreferredSize(new Dimension(1, separator.getPreferredSize().width));
			nestedPanel.add(separator);
		}

		if( jscrollPane != null )
			remove(jscrollPane);

		jscrollPane = new JScrollPane(nestedPanel);

		add(jscrollPane);

	    resetDisplayedData(profileGrid);
	}

	public JScrollPane getScrollPanel()
	{
		return jscrollPane;
	}
}