package jprofilegrid.view.overview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;

import jprofilegrid.model.Cell;
import jprofilegrid.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.format.Alignment;
import jxl.format.RGB;
import jxl.write.WritableCellFormat;


public class ProfileGridTableCellRenderer extends DefaultTableCellRenderer
{
	private static final long serialVersionUID = -686000339606310665L;
	Component cell;
	Object value;
	WritableCellFormat cellFormat;
	private static DecimalFormat formatter = new DecimalFormat();
	public static int BORDER_THICKNESS = 2;

	static
	{
		formatter.setMaximumFractionDigits(2);
		formatter.setMinimumFractionDigits(2);
		formatter.setMaximumIntegerDigits(1);
		formatter.setMinimumIntegerDigits(1);
	}

	private void setBold()
	{
		if(((Cell)value).getFormat().isBold())
			cell.setFont(new Font("Times New Roman", Font.BOLD, 12));
		else
			cell.setFont(new Font("Times New Roman", Font.PLAIN, 12));
	}

	private void setBorders()
	{
		if( cellFormat.hasBorders() )
		{
			RGB topBorderColor =
				cellFormat.getBorderColour(jxl.format.Border.TOP).getDefaultRGB();
			Color topColor;
			if(topBorderColor.getRed() == 255 && topBorderColor.getBlue() == 255 && topBorderColor.getGreen() == 255)
				topColor = cell.getBackground();
			else
				topColor = new Color(topBorderColor.getRed(), topBorderColor.getGreen(), topBorderColor.getBlue() );
			Border top = BorderFactory.createMatteBorder(BORDER_THICKNESS, 0,0,0, topColor);

			RGB bottomBorderColor =
				cellFormat.getBorderColour(jxl.format.Border.BOTTOM).getDefaultRGB();
			Color bottomColor;
			if(bottomBorderColor.getRed() == 255 && bottomBorderColor.getBlue() == 255 && bottomBorderColor.getGreen() == 255)
				bottomColor = cell.getBackground();
			else
				bottomColor = new Color(bottomBorderColor.getRed(), bottomBorderColor.getGreen(), bottomBorderColor.getBlue() );
			Border bottom = BorderFactory.createMatteBorder(0, 0,BORDER_THICKNESS,0,bottomColor);

			RGB leftBorderColor =
				cellFormat.getBorderColour(jxl.format.Border.LEFT).getDefaultRGB();
			Color leftColor;
			if(leftBorderColor.getRed() == 255 && leftBorderColor.getBlue() == 255 && leftBorderColor.getGreen() == 255)
				leftColor = cell.getBackground();
			else
				leftColor = new Color(leftBorderColor.getRed(), leftBorderColor.getGreen(), leftBorderColor.getBlue() );
			Border left = BorderFactory.createMatteBorder(0, BORDER_THICKNESS,0,0, leftColor);

			RGB rightBorderColor =
				cellFormat.getBorderColour(jxl.format.Border.RIGHT).getDefaultRGB();
			Color rightColor;
			if(rightBorderColor.getRed() == 255 && rightBorderColor.getBlue() == 255 && rightBorderColor.getGreen() == 255)
				rightColor = cell.getBackground();
			else
				rightColor = new Color(rightBorderColor.getRed(), rightBorderColor.getGreen(), rightBorderColor.getBlue() );
			Border right = BorderFactory.createMatteBorder(0, 0,0,BORDER_THICKNESS, rightColor);


			CompoundBorder topAndBottom = new CompoundBorder( top, bottom );
			CompoundBorder leftAndRight = new CompoundBorder( left, right );

			setBorder( new CompoundBorder( topAndBottom, leftAndRight ));
		}
	}

	private void setBackgroundColor()
	{
		RGB rgbBackColor =
			cellFormat.getBackgroundColour().getDefaultRGB();

		Color backColor = new Color(rgbBackColor.getRed(), rgbBackColor.getGreen(), rgbBackColor.getBlue() );

		cell.setBackground(backColor);
	}

	private void setForegroundColor()
	{
		RGB foreGroundColor =
			cellFormat.getFont().getColour().getDefaultRGB();

		Color foreColor = new Color(foreGroundColor.getRed(), foreGroundColor.getGreen(), foreGroundColor.getBlue() );

		cell.setForeground(foreColor);
	}

	private void setAlignment()
	{
		if( cellFormat.getAlignment() == Alignment.CENTRE)
			super.setHorizontalAlignment(JLabel.CENTER);
		if( cellFormat.getAlignment() == Alignment.RIGHT)
			setAlignmentY(JLabel.RIGHT);
		if( cellFormat.getAlignment() == Alignment.LEFT)
			setAlignmentY(JLabel.LEFT);
	}

	public Component getTableCellRendererComponent(JTable table, Object nValue, boolean isSelected,
            boolean hasFocus, int row, int column)
	{
		cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		value = nValue;
		cellFormat = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat((Cell)value);

		setText("");
		setBackgroundColor();
		setBold();
		setBorders();
		setAlignment();
		setForegroundColor();

		if(isSelected)
		{
			int reductionAmount = 100;
			int red   = getBackground().getRed()   > reductionAmount ? getBackground().getRed()   - reductionAmount : 0;
			int green = getBackground().getGreen() > reductionAmount ? getBackground().getGreen() - reductionAmount : 0;
			int blue  = getBackground().getBlue()  > reductionAmount ? getBackground().getBlue()  - reductionAmount : 0;
			Color shadedBackground = new Color(red, green, blue);
			cell.setBackground(shadedBackground);
		}

		return cell;
	}

}
