package jprofilegrid.view.profilegrid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.*;
import javax.swing.*;

import jprofilegrid.constants.AminoAcidConstants;
import jprofilegrid.model.Cell;
import jprofilegrid.model.Text;
import jprofilegrid.writers.excel.ProfileGridFormatToExcelFormatConverter;
import jxl.format.RGB;
import jxl.write.WritableCellFormat;


public class FixedAAColumnInTable extends DefaultTableCellRenderer
{
	private static final long serialVersionUID = -3483011388216552532L;
	
	public static int BORDER_THICKNESS = 2;
	
	Component cell;
	Object value;
	WritableCellFormat cellFormat;
	
	private Color defaultBackground;
	private boolean isTaylorSort = false;
	private boolean showText = true;
	
	public FixedAAColumnInTable(boolean isTaylorSort, boolean showText)
	{
		this.isTaylorSort = isTaylorSort;
		this.showText = showText;
		this.defaultBackground = getBackground();
	}

	public Component getTableCellRendererComponent(JTable table, Object nValue, boolean isSelected,
            boolean hasFocus, int row, int column)
	{
		cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		value = nValue;
		cellFormat = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat((Cell)value);

		setText(((Text)nValue).getValue() == null ? "" : ((Text)nValue).getValue());
		
		
		Color color = AminoAcidConstants.aaColorMaps.get(getText());

		if(!showText)
			setText("");
		
		if(color != null && isTaylorSort)
			setBackground(color);
		else
			setBackground(defaultBackground);
		setFont(new Font("Times New Roman", Font.BOLD, 12));
	    setAlignmentX(JLabel.CENTER_ALIGNMENT);
	    if(cellFormat.hasBorders())
		    setBorders();
	    else
	    	setBorder(UIManager.getBorder("TableHeader.cellBorder"));
	    
	    super.setHorizontalAlignment(JLabel.CENTER);
	    return this;
	}
	
	private void setBorders()
	{
		if( cellFormat.hasBorders() )
		{
			RGB topBorderColor = 
				cellFormat.getBorderColour(jxl.format.Border.TOP).getDefaultRGB();
			Color topColor;
			if(topBorderColor.getRed() == 255 && topBorderColor.getBlue() == 255 && topBorderColor.getGreen() == 255)
				topColor = cell.getBackground();
			else
				topColor = new Color(topBorderColor.getRed(), topBorderColor.getGreen(), topBorderColor.getBlue() );
			Border top = BorderFactory.createMatteBorder(BORDER_THICKNESS, 0,0,0, topColor);
				
			RGB bottomBorderColor = 
				cellFormat.getBorderColour(jxl.format.Border.BOTTOM).getDefaultRGB();
			Color bottomColor;
			if(bottomBorderColor.getRed() == 255 && bottomBorderColor.getBlue() == 255 && bottomBorderColor.getGreen() == 255)
				bottomColor = cell.getBackground();
			else
				bottomColor = new Color(bottomBorderColor.getRed(), bottomBorderColor.getGreen(), bottomBorderColor.getBlue() );
			Border bottom = BorderFactory.createMatteBorder(0, 0,BORDER_THICKNESS,0,bottomColor);
			
			RGB leftBorderColor = 
				cellFormat.getBorderColour(jxl.format.Border.LEFT).getDefaultRGB();
			Color leftColor;
			if(leftBorderColor.getRed() == 255 && leftBorderColor.getBlue() == 255 && leftBorderColor.getGreen() == 255)
				leftColor = cell.getBackground();
			else
				leftColor = new Color(leftBorderColor.getRed(), leftBorderColor.getGreen(), leftBorderColor.getBlue() );
			Border left = BorderFactory.createMatteBorder(0, BORDER_THICKNESS,0,0, leftColor);
			
			RGB rightBorderColor = 
				cellFormat.getBorderColour(jxl.format.Border.RIGHT).getDefaultRGB();
			Color rightColor;
			if(rightBorderColor.getRed() == 255 && rightBorderColor.getBlue() == 255 && rightBorderColor.getGreen() == 255)
				rightColor = cell.getBackground();
			else
				rightColor = new Color(rightBorderColor.getRed(), rightBorderColor.getGreen(), rightBorderColor.getBlue() );
			Border right = BorderFactory.createMatteBorder(0, 0,0,BORDER_THICKNESS, rightColor);
			
			
			CompoundBorder topAndBottom = new CompoundBorder( top, bottom );
			CompoundBorder leftAndRight = new CompoundBorder( left, right );
			
			setBorder( new CompoundBorder( topAndBottom, leftAndRight ));
		}
	}
}
