package jprofilegrid.view.profilegrid;

import java.awt.BorderLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import jprofilegrid.model.ProfileGrid;
import jprofilegrid.presenter.ProfileGridPresenter;
import jprofilegrid.view.OpenWindowsMenu;

public class ProfileGridJFrame extends JFrame implements ActionListener
{
	private static final long serialVersionUID = 2296482860188831605L;

	private MenuBar menuBar = new MenuBar();
	private Menu fileMenu = new Menu("File");
	private Menu aboutMenu = new Menu("About");

	private MenuItem aboutMenuItem = new MenuItem("JProfileGrid");
	private MenuItem quitMenuItem = new MenuItem("Quit");

	private ProfileGridJPanel topProfileGridJPanel, bottomProfileGridJPanel;

	private DualDisplaySubJPanel dualDisplaySubJPanel = new DualDisplaySubJPanel();

	private boolean dualDisplayEnabled = false;

	// Variable that denotes whether or not the overview JFrame is visible.
	boolean overviewJFrameVisible = false;

	private ProfileGridPresenter profileGridPresenter;

	public ProfileGridJFrame(ProfileGridPresenter profileGridPresenter)
	{
		this.profileGridPresenter = profileGridPresenter;
		topProfileGridJPanel    = new ProfileGridJPanel(profileGridPresenter);
		bottomProfileGridJPanel = new ProfileGridJPanel(profileGridPresenter);

		topProfileGridJPanel.setDualDisplay(bottomProfileGridJPanel);
		bottomProfileGridJPanel.setDualDisplay(topProfileGridJPanel);

		setLayout(new BorderLayout());
		add(topProfileGridJPanel, BorderLayout.NORTH);
//		dualDisplaySubJPanel.setActiveGridIndicatorVisible(false);
		add(dualDisplaySubJPanel, BorderLayout.SOUTH);
		initializeMenuBar();
		setDefaultCloseOperation(HIDE_ON_CLOSE);
	}

	private void initializeMenuBar()
	{
		menuBar.add(fileMenu);
		OpenWindowsMenu openWindowsMenu = new OpenWindowsMenu();
		addWindowListener(openWindowsMenu);
		menuBar.add(openWindowsMenu);
		menuBar.add(aboutMenu);
		quitMenuItem.addActionListener(this);
		aboutMenu.add(aboutMenuItem);
		aboutMenuItem.addActionListener(this);
		fileMenu.add(quitMenuItem);
		setMenuBar((menuBar));
	}

	public void setDualDisplay(boolean ddEnabled)
	{
		dualDisplayEnabled = ddEnabled;

//		dualDisplaySubJPanel.setActiveGridIndicatorVisible(dualDisplayEnabled);

		if(dualDisplayEnabled)
		{
			remove(topProfileGridJPanel);
			remove(bottomProfileGridJPanel);
			remove(dualDisplaySubJPanel);

//			topProfileGridJPanel.setDualDisplay(bottomProfileGridJPanel);
			add(topProfileGridJPanel, BorderLayout.NORTH);

//			bottomProfileGridJPanel.setDualDisplay(topProfileGridJPanel);
			bottomProfileGridJPanel.setIsInFocus(false);

			add(bottomProfileGridJPanel, BorderLayout.CENTER);
		}
		else
		{
			remove(topProfileGridJPanel);
			remove(bottomProfileGridJPanel);
			remove(dualDisplaySubJPanel);

			add(topProfileGridJPanel, BorderLayout.NORTH);
		}

		add(dualDisplaySubJPanel, BorderLayout.SOUTH);
	}

	public void resetTopProfileGrid(String title, ProfileGrid topProfileGrid)
	{
		setTitle(title);
		topProfileGridJPanel.setProfileGrid(topProfileGrid);
		pack();
	}

	public void resetBottomProfileGrid(ProfileGrid bottomProfileGrid)
	{
		bottomProfileGridJPanel.setProfileGrid(bottomProfileGrid);
		pack();
	}

	public void actionPerformed(ActionEvent event)
	{
		if( event.getSource() == quitMenuItem )
			System.exit(0);
		if( event.getSource() == aboutMenuItem )
		{
			profileGridPresenter.showAboutDialog();
			return;
		}
	}

	private void enableLockedScrolling()
	{
		topProfileGridJPanel.setScrollLock(true);
		bottomProfileGridJPanel.setScrollLock(true);
	}

	private void disableLockedScrolling()
	{
		topProfileGridJPanel.setScrollLock(false);
		bottomProfileGridJPanel.setScrollLock(false);
	}

	private class DualDisplaySubJPanel extends JPanel implements ActionListener
	{
		private static final long serialVersionUID = -2281446840864021327L;

//		private JLabel activeGridInfoJLabel	= new JLabel("Active Grid:");
//		private JComboBox activeGridJComboBox = new JComboBox(new String[] {"Top", "Bottom"});

		private JLabel dualDisplayModeJLabel = new JLabel("Dual Display Mode:");
		private JComboBox dualDisplayModesJComboBox = new JComboBox(new String[] {"Single Display",
				"Pseudo Mirror", "Selection"/*, "Quality Scores"*/});
		private JLabel lockScrollJLabel = new JLabel("Lock Horizontal Scroll:");
		private JCheckBox toggleLockScrollJCheckBox = new JCheckBox();

		public DualDisplaySubJPanel()
		{
/*			activeGridJComboBox.addActionListener(this);
			add(activeGridInfoJLabel);
			add(activeGridJComboBox);
*/
			add(dualDisplayModeJLabel);
			dualDisplayModesJComboBox.addActionListener(this);

			add(dualDisplayModesJComboBox);
			add(lockScrollJLabel);

			toggleLockScrollJCheckBox.addActionListener(this);
			add(toggleLockScrollJCheckBox);
		}
/*
		public void focusOnTop()
		{
			activeGridJComboBox.setSelectedIndex(0);
		}

		public void focusOnBottom()
		{
			activeGridJComboBox.setSelectedIndex(1);
		}

		public void setActiveGridIndicatorVisible(boolean visible)
		{
			activeGridInfoJLabel.setVisible(visible);
			activeGridJComboBox.setVisible(visible);
		}
*/
		public void actionPerformed(ActionEvent e)
		{
			if( e.getSource() == toggleLockScrollJCheckBox )
				if( toggleLockScrollJCheckBox.isSelected() )
					enableLockedScrolling();
				else
					disableLockedScrolling();

			if( e.getSource() == dualDisplayModesJComboBox )
			{
				profileGridPresenter.setDualDisplayMode(dualDisplayModesJComboBox.getSelectedIndex());
			}
/*
			if(e.getSource() == activeGridJComboBox)
			{
				if(activeGridJComboBox.getSelectedIndex() == 0)
					topProfileGridJPanel.symbolSideBarsJTable.requestFocus();
				else
					bottomProfileGridJPanel.symbolSideBarsJTable.requestFocus();
			}
			*/
		}


		public boolean getTopGridIsActive()
		{
			return true;
		//	return activeGridJComboBox.getSelectedIndex() == 0;
		}
		public boolean getSelectionModeEnabled()
		{
			return dualDisplayModesJComboBox.getSelectedIndex() == 2;
		}
	}
/*
	public void focusOnTop()
	{
		dualDisplaySubJPanel.focusOnTop();
	}

	public void focusOnBottom()
	{
		dualDisplaySubJPanel.focusOnBottom();
	}
*/
	public void loadHorizontalScrollPositions()
	{
		topProfileGridJPanel.saveHorizontalScrollPosition();
		if(dualDisplayEnabled)
			bottomProfileGridJPanel.saveHorizontalScrollPosition();
	}

	public void saveHorizontalScrollPositions()
	{
		topProfileGridJPanel.loadHorizontalScrollPosition();
		if(dualDisplayEnabled)
			bottomProfileGridJPanel.loadHorizontalScrollPosition();
	}


	public boolean getTopGridIsActive()
	{
		return dualDisplaySubJPanel.getTopGridIsActive();
	}

	public boolean getDualDisplayEnabled()
	{
		return dualDisplayEnabled;
	}

	public boolean getSelectionModeEnabled()
	{
		return dualDisplaySubJPanel.getSelectionModeEnabled();
	}

	public int getTopProfileGridSelectedRow()
	{
		return topProfileGridJPanel.getSelectedRow();
	}

	public int getTopProfileGridSelectedColumn()
	{
		return topProfileGridJPanel.getSelectedColumn();
	}
}
