package jprofilegrid.view.profilegrid;

import javax.swing.table.AbstractTableModel;

import jprofilegrid.model.Cell;
import jprofilegrid.model.Format;
import jprofilegrid.model.Text;

public class ProfileGridTableModel extends AbstractTableModel 
{
	private int numRows = 0;
	private int numColumns = 0;
	private static final long serialVersionUID = 7964221551041651140L;
	private Cell[][] data;
	
	public ProfileGridTableModel()
	{
		data = new Cell[0][0];
	}
	
	public ProfileGridTableModel(int nNumRows, int nNumColumns)
	{
		numRows = nNumRows;
		numColumns = nNumColumns;
		data = new Cell[numRows][numColumns];
		
		for( int i = 0; i < numRows; i++ )
			for( int j = 0; j < numColumns; j++ )
				data[i][j] = new Text(new Format(Format.CENTER_ALIGNED,Format.BOLD), "");
	}

	public Class<?> getColumnClass(int columnIndex) 
	{
		if( getValueAt(0, columnIndex) != null )
			return getValueAt(0, columnIndex).getClass();
		else
			return null;
	}

	public int getColumnCount() 
	{
		return numColumns;
	}

	public String getColumnName(int columnIndex) 
	{
		return "";
	}

	public int getRowCount() 
	{
		return numRows;
	}

	public Object getValueAt(int rowIndex, int columnIndex) 
	{
		return data[rowIndex][columnIndex];
	}

	public boolean isCellEditable(int rowIndex, int columnIndex) 
	{
		return false;
	}

	public void setValueAt(Cell value, int rowIndex, int columnIndex) 
	{
		data[rowIndex][columnIndex] =  value;
	}

}
