package jprofilegrid.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import jprofilegrid.calculations.MultipleSequenceAlignment;
import jprofilegrid.calculations.Sequence;
import jprofilegrid.model.AnalysisOptions;

public class FASTAFileWriter
{
	public static void writeFASTAFile(final String  filename, final MultipleSequenceAlignment msa, AnalysisOptions analysisOptions)
	{
		final List<Integer> sequenceIndicesInMSA = analysisOptions.sequenceIndicesInMSA;
		File file = new File(filename);
		try
		{
			FileWriter fileWriter = new FileWriter(file);
			BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);

			List<Sequence> sequences = msa.getSequences();
			for(int i = 0; i < sequenceIndicesInMSA.size(); i++)
			{
				Sequence sequence = sequences.get(sequenceIndicesInMSA.get(i));

				bufferedWriter.write(">" + sequence.getName() + "\n");

				int blockSize = 60;
				String sequenceString = sequence.getSequence();
				int numBlocks = sequenceString.length() / blockSize;
				int leftOver  = sequenceString.length() % blockSize;
				int j;
				for(j = 0; j < numBlocks; j++)
				{
					int start = j * blockSize;
					int end   = start + blockSize;

					bufferedWriter.write(sequenceString.substring(start, end));

					if(j != numBlocks - 1)
						bufferedWriter.write("\n");
				}

				if(leftOver != 0)
					bufferedWriter.write("\n" + sequenceString.substring(j * numBlocks, (j * numBlocks) + leftOver));

				if(i != sequences.size() - 1)
					bufferedWriter.write("\n");
			}


			bufferedWriter.close();
		}
		catch (IOException ioException)
		{
		}
	}
}
