package jprofilegrid.writers.excel;

import jxl.format.Alignment;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WriteException;
import jxl.format.Colour;

public class DefaultFonts 
{
	/*
	 * Same as getDefaultFormatWithBackgroundColour, but also centered.
	 */
	public static WritableCellFormat getDefaultFormatWithBackgroundColourAndCentered(Colour colour)
	{
		WritableCellFormat format = getDefaultFormatWithBackgroundColour(colour);
		try
		{
			format.setAlignment(Alignment.CENTRE);
		}
		catch(WriteException e)
		{
		}
		
		return format;
	}
	
	/*
	 * Returns a WritableCellFormat with the default format and specified Colour
	 * as its background.
	 */
	public static WritableCellFormat getDefaultFormatWithBackgroundColour(Colour colour)
	{
		WritableCellFormat format = new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12));
		try
		{
			format.setBackground(colour);
			enableShrinkToFit( format );
			setDefaultAlignment( format );
		}
		catch(WriteException e)
		{
		}
		
		return format;
	}
	
	/*
	 * Same as getDefaultFormat(), but also centered;
	 */
	public static WritableCellFormat getDefaultFormatAndCentered()
	{
		WritableCellFormat format = getDefaultFormat();
		try
		{
			format.setAlignment(Alignment.CENTRE);
		}
		catch(WriteException e)
		{
		}
		
		return format;
	}
	
	/*
	 * Returns a WritableCellFormat with the default format, alignment, and shrinkToFit enabled.
	 */
	public static WritableCellFormat getDefaultFormat()
	{
		WritableCellFormat defaultFont = new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12));
		enableShrinkToFit( defaultFont );
		setDefaultAlignment( defaultFont );
		return(defaultFont);
	}
	
	/*
	 * Returns a WritableCellFormat array with the default format.
	 */
	public static WritableCellFormat[] getDefaultFormatBlock(int lengthOfBlock)
	{
		WritableCellFormat[] block = new WritableCellFormat[lengthOfBlock];
		for( int i = 0; i < block.length; i++ )
			block[i] = getDefaultFormat();
		return block;
	}
	
	/*
	 * Returns a WritableCellFormat double array with the default format.
	 */
	public static WritableCellFormat[][] getDefaultFormatBlock(int lengthOfBlock, int widthOfBlock)
	{
		WritableCellFormat[][] block = new WritableCellFormat[lengthOfBlock][widthOfBlock];
		for( int i = 0; i < block.length; i++ )
			block[i] = getDefaultFormatBlock(widthOfBlock);
		return block;
	}
	
	/*
	 * Returns a WritableCellFormat with the default format in bold, alignment, and shrinkToFit enabled.
	 */
	public static WritableCellFormat getBold()
	{
		WritableCellFormat defaultFontInBold = 
			new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD));
		enableShrinkToFit( defaultFontInBold );
		setDefaultAlignment( defaultFontInBold );
		return defaultFontInBold;
	}

	/*
	 * Returns a WritableCellFormat with the default format in bold and centered.
	 */
	public static WritableCellFormat getBoldAndCentered()
	{
		WritableCellFormat format = getBold();
		try
		{
			format.setAlignment(Alignment.CENTRE);
		}
		catch(WriteException e)
		{
		}
		
		return format;
	}

	/*
	 * Returns an array of WritableCellFormats that have all been
	 * initialized to the default font in bold and centered.
	 */
	public static WritableCellFormat[] getBoldAndCenteredBlock( int lengthOfBlock )
	{
		WritableCellFormat[] block = new WritableCellFormat[lengthOfBlock];
		for( int i = 0; i < block.length; i++ )
			block[i] = getBoldAndCentered();
		return(block);
	}
	
	/*
	 * Returns a WritableCellFormat object that have has been
	 * initialized to the default font in bold and right-aligned.
	 */
	public static WritableCellFormat getBoldAndRightAligned()
	{
		WritableCellFormat format = getBold();
		try
		{
			format.setAlignment(Alignment.RIGHT);
		}
		catch(WriteException e)
		{
		}
		
		return format;
	}

	/*
	 * Returns an array of WritableCellFormats that have all been
	 * initialized to the default font in bold.
	 */
	public static WritableCellFormat[] getBoldBlock( int lengthOfBlock )
	{
		WritableCellFormat[] block = new WritableCellFormat[lengthOfBlock];
		for( int i = 0; i < block.length; i++ )
			block[i] = new WritableCellFormat(new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD));
		return(block);
	}

	private static void enableShrinkToFit( WritableCellFormat format )
	{
		try
		{
			format.setShrinkToFit(true);
		}
		catch(WriteException e)
		{
		}
	}
	
	private static void setDefaultAlignment( WritableCellFormat format )
	{
		try
		{
			format.setAlignment(Alignment.RIGHT);
		}
		catch(WriteException e)
		{
		}
	}
}
