package jprofilegrid.writers.excel;

import jprofilegrid.model.Cell;
import jprofilegrid.model.Numeric;
import jprofilegrid.model.Text;
import jxl.write.WritableCellFormat;

/*
 * In order to simplify conversion from the ProfileGrid class
 * to the JExcelAPI format, this class performs a number of
 * conversion functions.
 */
public abstract class ProfileGridCellToExcelCellConverter
{
	/** Converts an array of Numeric or Cells to an
	 * array of ExcelTextCells.
	 */
	public static ExcelCell[][] getCells( Cell[][] cells )
	{
		ExcelCell[][] excelCells = new ExcelCell[cells.length][];
		for(int i = 0; i < cells.length; i++)
			excelCells[i] = getCells( cells[i] );

		return excelCells;
	}

	/*
	 * Converts an array of ProfileGrid Text format
	 * cells to the ExcelTextCell format.
	 */
	public static ExcelCell[] getCells( Cell[] cells )
	{
		ExcelCell[] excelCells = new ExcelCell[cells.length];
		for( int i = 0; i < excelCells.length; i++ )
			excelCells[i] = getCell( cells[i] );

		return excelCells;
	}

	/**
	 * Converts a Cell to an ExcelTextCell.
	 */
	private static ExcelCell getCell(Cell cell)
	{
		if(cell instanceof Numeric)
			return getNumericCell((Numeric)cell);

		return getTextCell((Text)cell);
	}

	/*
	 * Converts a cell in the ProfileGrid Numeric format
	 * to the ExcelNumericCell format.
	 */
	private static ExcelNumericCell getNumericCell( Numeric cell )
	{
		WritableCellFormat format = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat( cell );

		double value = cell.getValue();

		return( new ExcelNumericCell( format, value ) );
	}

	/*
	 * Converts a cell in the ProfileGrid Text format
	 * to the ExcelTextCell format. This allows the
	 * ExcelFileWriter to process the cell.
	 */
	private static ExcelTextCell getTextCell( Text cell )
	{
		WritableCellFormat format = ProfileGridFormatToExcelFormatConverter.extractWritableCellFormat( cell );
		String value = cell.getValue();

		return( new ExcelTextCell( format, value ) );
	}
}
