package jprofilegrid.writers.excel;

import jprofilegrid.model.Cell;
import jprofilegrid.model.Format;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Alignment;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WriteException;
import jxl.format.Colour;

public class ProfileGridFormatToExcelFormatConverter
{
	public static Colour[] JEXCELAPI_COLORS = {Colour.WHITE, Colour.GRAY_25,
		Colour.YELLOW, Colour.ORANGE, Colour.GREEN, Colour.RED, Colour.SKY_BLUE };

	/*
	 * This method converts a profileGrid.Cell object's format into a WritableCellFormat object.
	 */
	public static WritableCellFormat extractWritableCellFormat( Cell cell )
	{
		Format oldFormat = cell.getFormat();
		WritableCellFormat newFormat;
		if(oldFormat.isBold())
			newFormat = new WritableCellFormat(
				new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD));
		else
			newFormat = new WritableCellFormat(
					new WritableFont(WritableFont.TIMES, 12, WritableFont.NO_BOLD));

		extractBorders( oldFormat, newFormat );
		extractAlignment( oldFormat, newFormat );
		extractBackgroundColor( oldFormat, newFormat );
		extractBorderColor( oldFormat, newFormat );

		try
		{
			newFormat.setShrinkToFit(true);
		}
		catch(WriteException e)
		{
		}
		return( newFormat );
	}

	private static void extractBorders( Format oldFormat, WritableCellFormat newFormat )
	{
		try
		{
			if( oldFormat.hasTopBorder() )
				newFormat.setBorder(Border.TOP, BorderLineStyle.MEDIUM);
			if( oldFormat.hasBottomBorder() )
				newFormat.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
			if( oldFormat.hasLeftBorder() )
				newFormat.setBorder(Border.LEFT, BorderLineStyle.MEDIUM);
			if( oldFormat.hasRightBorder() )
				newFormat.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
		}
		catch(WriteException e)
		{
		}
	}

	private static void extractBorderColor( Format oldFormat, WritableCellFormat newFormat )
	{
		try
		{
			Colour newColour = oldFormat.getBorderColor();
			if( newColour != null )
			{
				newFormat.setBorder(Border.LEFT, BorderLineStyle.MEDIUM, newColour);
				newFormat.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM, newColour);
				newFormat.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM, newColour);
				newFormat.setBorder(Border.TOP, BorderLineStyle.MEDIUM, newColour);
			}
		}
		catch(WriteException e)
		{
		}
	}

	private static void extractAlignment(Format oldFormat, WritableCellFormat newFormat)
	{
		try
		{
			newFormat.setAlignment(convertAlignment(oldFormat.getAlignment()));
		}
		catch(WriteException e)
		{
		}
	}

	private static void extractBackgroundColor( Format oldFormat, WritableCellFormat newFormat )
	{
		try
		{
			Colour newColour = oldFormat.getBackgroundColor();
			if( newColour != null )
			{
				newFormat.setBackground(newColour);

				if( newColour.getDefaultRGB().getGreen() < 255 * .6)
				{
					WritableFont newFont = new WritableFont( newFormat.getFont() );
					newFont.setColour(Colour.WHITE);
					newFormat.setFont(newFont);
				}
			}
		}
		catch(WriteException e)
		{
		}
	}

	/*
	 * Converts the alignment member variable of a ProfileGrid format object to the
	 * in the JExcelAPI format.
	 */
	private static Alignment convertAlignment( int oldAlignment )
	{
		if( oldAlignment == Format.LEFT_ALIGNED )
			return Alignment.LEFT;
		if( oldAlignment == Format.CENTER_ALIGNED )
			return Alignment.CENTRE;
		if( oldAlignment == Format.RIGHT_ALIGNED )
			return Alignment.RIGHT;

		return null;
	}
}
